/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.verify;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.catools.common.collections.CList;
import org.catools.common.concurrent.CSleeper;
import org.catools.common.config.CConfigs;
import org.catools.common.date.CDate;
import org.catools.common.exception.CRuntimeException;
import org.catools.common.logger.CLogger;
import org.catools.common.text.CStringUtil;
import org.catools.common.text.match.CStringDiff;

public class CVerificationInfo<A, E> {
    private final A actual;
    private final E expected;
    private final String message;
    private final boolean printDiff;
    private final int waitInSeconds;
    private final int intervalInMilliSeconds;
    private final BiFunction<A, E, Boolean> verifyMethod;
    private final BiConsumer<A, E> onFail;

    public CVerificationInfo(A actual, E expected, String message, boolean printDiff, BiFunction<A, E, Boolean> verifyMethod) {
        this(actual, expected, message, printDiff, -1, -1, verifyMethod);
    }

    public CVerificationInfo(A actual, E expected, String message, boolean printDiff, BiFunction<A, E, Boolean> verifyMethod, BiConsumer<A, E> onFail) {
        this(actual, expected, message, printDiff, -1, -1, verifyMethod, onFail);
    }

    public CVerificationInfo(A actual, E expected, String message, boolean printDiff, int waitInSeconds, int intervalInMilliSeconds, BiFunction<A, E, Boolean> verifyMethod) {
        this(actual, expected, message, printDiff, waitInSeconds, intervalInMilliSeconds, verifyMethod, null);
    }

    public CVerificationInfo(A actual, E expected, String message, boolean printDiff, int waitInSeconds, int intervalInMilliSeconds, BiFunction<A, E, Boolean> verifyMethod, BiConsumer<A, E> onFail) {
        this.actual = actual;
        this.expected = expected;
        this.message = message;
        this.printDiff = printDiff;
        this.verifyMethod = verifyMethod;
        this.waitInSeconds = waitInSeconds;
        this.intervalInMilliSeconds = intervalInMilliSeconds;
        this.onFail = onFail;
    }

    public boolean test(CLogger logger, CList<String> verificationMessages) {
        Boolean result = this.computerResult(logger);
        if (result.booleanValue()) {
            if (CConfigs.Logger.logPassedVerification()) {
                logger.pass(this.getMessage(true), new Object[0]);
            }
        } else {
            String message = this.getMessage(false);
            logger.fail(message, new Object[0]);
            verificationMessages.add(message);
        }
        return result;
    }

    private Boolean computerResult(CLogger logger) {
        if (this.waitInSeconds != -1) {
            return this.computerResultWithWait(logger);
        }
        Boolean result = false;
        try {
            result = this.verifyMethod.apply(this.actual, this.expected);
        }
        finally {
            if (!result.booleanValue()) {
                this.applyOnFail(logger);
            }
        }
        return result;
    }

    private Boolean computerResultWithWait(CLogger logger) {
        boolean isTimeOuted = false;
        Throwable lastException = null;
        CDate deadLine = new CDate().addSeconds(this.waitInSeconds);
        do {
            try {
                boolean result = this.verifyMethod.apply(this.actual, this.expected);
                if (result) {
                    return true;
                }
                CSleeper.sleepTight(this.intervalInMilliSeconds);
            }
            catch (Throwable t) {
                lastException = t;
            }
        } while (!deadLine.before(CDate.now()));
        isTimeOuted = true;
        this.applyOnFail(logger);
        if (lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new CRuntimeException(lastException);
        }
        return !isTimeOuted;
    }

    private void applyOnFail(CLogger logger) {
        if (this.onFail != null) {
            try {
                this.onFail.accept(this.actual, this.expected);
            }
            catch (Throwable t) {
                logger.error(t);
            }
        }
    }

    private String getMessage(boolean passed) {
        String text1 = this.getString(this.expected);
        String text2 = this.getString(this.actual);
        if (!passed && this.printDiff) {
            String diff = CConfigs.Logger.logColoredOutput() ? CStringDiff.coloredDiff(text1, text2, CConfigs.StringDiff.getDiffEditCost()) : CStringDiff.prettyDiff(text1, text2, CConfigs.StringDiff.getDiffEditCost());
            return CStringUtil.format("%s.\\nDiff: '%s',\\nExp: '%s',\\nAct: '%s'", this.message, diff, text1, text2);
        }
        return CStringUtil.format("%s. Exp: '%s', Act: '%s'", this.message, text1, text2);
    }

    private String getString(Object obj) {
        if (obj == null) {
            return "<NULL>";
        }
        return obj.getClass().isArray() ? new CList<String>((String[])obj).toString() : "" + obj;
    }
}

