/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.verify;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.catools.common.collections.CList;
import org.catools.common.extensions.verify.CVerificationBuilder;
import org.catools.common.extensions.verify.CVerificationException;
import org.catools.common.extensions.verify.CVerificationInfo;
import org.catools.common.logger.CLogger;
import org.catools.common.tests.CTest;
import org.catools.common.text.CStringUtil;

public class CVerifier
extends CVerificationBuilder<CVerifier> {
    private static final String line = "------------------------------------------------------------";
    protected final CList<CVerificationInfo> expectations = new CList();

    public CVerifier(CTest testInstance) {
        super(testInstance.logger);
    }

    public CVerifier(CLogger logger) {
        super(logger);
    }

    @Override
    public CVerifier queue(CVerificationInfo verificationInfo) {
        this.expectations.add(verificationInfo);
        return this;
    }

    public boolean verify() {
        return this.verify("");
    }

    public boolean verify(String header) {
        return this.perform(header, "Verify All", messages -> {
            AtomicBoolean result = new AtomicBoolean(true);
            this.expectations.forEach(expectation -> {
                if (!expectation.test(this.logger, (CList<String>)messages)) {
                    result.set(false);
                }
            });
            return result.get();
        });
    }

    public boolean verifyAny() {
        return this.verifyAny("");
    }

    public boolean verifyAny(String header) {
        return this.perform(header, "Verify Any", messages -> {
            AtomicBoolean result = new AtomicBoolean(false);
            this.expectations.forEach(expectation -> {
                if (expectation.test(this.logger, (CList<String>)messages)) {
                    result.set(true);
                }
            });
            return result.get();
        });
    }

    public boolean verifyNone() {
        return this.verifyNone("");
    }

    public boolean verifyNone(String header) {
        return this.perform(header, "Verify None", messages -> {
            AtomicBoolean result = new AtomicBoolean(true);
            this.expectations.forEach(expectation -> {
                if (expectation.test(this.logger, (CList<String>)messages)) {
                    result.set(false);
                }
            });
            return result.get();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean perform(String header, String verificationType, Function<CList<String>, Boolean> supplier) {
        CList<Object> messages = new CList<Object>();
        messages.add("==============" + verificationType + "==============");
        boolean hasHeader = CStringUtil.isNotBlank((CharSequence)header);
        if (hasHeader) {
            messages.add(line);
            messages.add(header);
            messages.add(line);
        }
        try {
            boolean result = supplier.apply(messages);
            if (hasHeader) {
                messages.add(line);
            }
            String verificationMessages = messages.join(System.lineSeparator());
            if (!result) {
                throw new CVerificationException(verificationMessages);
            }
            if (messages.size() > 1) {
                this.logger.info(verificationMessages, new Object[0]);
            }
        }
        finally {
            this.expectations.clear();
        }
        return true;
    }
}

