/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.verify;

import java.util.function.Function;
import org.catools.common.collections.CList;
import org.catools.common.extensions.verify.CVerificationBuilder;
import org.catools.common.extensions.verify.CVerificationException;
import org.catools.common.extensions.verify.CVerificationInfo;
import org.catools.common.logger.CLogger;

public class CVerify
extends CVerificationBuilder<CVerify> {
    public CVerify(CLogger logger) {
        super(logger);
    }

    @Override
    public CVerify queue(CVerificationInfo expectation) {
        this.perform(messages -> expectation.test(this.logger, (CList<String>)messages));
        return this;
    }

    private boolean perform(Function<CList<String>, Boolean> supplier) {
        CList messages = new CList();
        boolean result = supplier.apply(messages);
        String verificationMessages = messages.join(System.lineSeparator());
        if (!result) {
            throw new CVerificationException(verificationMessages);
        }
        this.logger.info(verificationMessages, new Object[0]);
        return true;
    }
}

