/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.verify.interfaces;

import java.util.function.Predicate;
import org.catools.common.collections.CList;
import org.catools.common.extensions.states.interfaces.CIterableState;
import org.catools.common.extensions.verify.CVerificationQueue;
import org.catools.common.extensions.verify.interfaces.CObjectVerifier;
import org.catools.common.utils.CIterableUtil;

public interface CIterableVerifier<E>
extends CObjectVerifier<Iterable<E>, CIterableState<E>> {
    @Override
    default public CIterableState<E> _toState(Object e) {
        return () -> (Iterable)e;
    }

    default public void verifyContains(CVerificationQueue verificationQueue, E expected) {
        this.verifyContains(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContains(CVerificationQueue verificationQueue, E expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> CIterableUtil.contains((Iterable)this.getBaseValue(), e), message, params);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds) {
        this.verifyContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, String message, Object ... params) {
        this.verifyContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> CIterableUtil.contains((Iterable)this.getBaseValue(), e), waitInSeconds, intervalInMilliSeconds, "Contains The Record");
    }

    default public void verifyContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> CIterableUtil.contains((Iterable)this.getBaseValue(), e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected) {
        this.verifyContainsAll(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            if (expected == null) {
                return false;
            }
            CList diff = new CList();
            this._toState(a).containsAll(e, e1 -> diff.add(e1));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diff, new Object[0]);
            }
            return diff.isEmpty();
        }, message, params);
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds) {
        this.verifyContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> {
            if (expected == null) {
                return false;
            }
            CList diff = new CList();
            this._toState(a).containsAll(e, e1 -> diff.add(e1));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diff, new Object[0]);
            }
            return diff.isEmpty();
        }, waitInSeconds, intervalInMilliSeconds, "Contains All Records");
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            if (expected == null) {
                return false;
            }
            CList diff = new CList();
            this._toState(a).containsAll(e, e1 -> diff.add(e1));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diff, new Object[0]);
            }
            return diff.isEmpty();
        }, waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Iterable<E> expected) {
        this.verifyContainsNone(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Iterable<E> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            CList diff = new CList();
            this._toState(a).containsNone(expected, e1 -> diff.add(e1));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list contains following records:\n" + diff, new Object[0]);
            }
            return !CIterableUtil.isEmpty(e) && diff.isEmpty();
        }, message, params);
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds) {
        this.verifyContainsNone(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyContainsNone(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> {
            CList diff = new CList();
            this._toState(a).containsNone(expected, e1 -> diff.add(e1));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list contains following records:\n" + diff, new Object[0]);
            }
            return !CIterableUtil.isEmpty(e) && diff.isEmpty();
        }, waitInSeconds, intervalInMilliSeconds, "Contains None Of Records");
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            CList diff = new CList();
            this._toState(a).containsNone(expected, e1 -> diff.add(e1));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list contains following records:\n" + diff, new Object[0]);
            }
            return !CIterableUtil.isEmpty(e) && diff.isEmpty();
        }, waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, E expected) {
        this.verifyEmptyOrContains(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, E expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrContains(e), message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds) {
        this.verifyEmptyOrContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, String message, Object ... params) {
        this.verifyEmptyOrContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).emptyOrContains(e), waitInSeconds, intervalInMilliSeconds, "Is Empty Or Contains The Record");
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrContains(e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, E expected) {
        this.verifyEmptyOrNotContains(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, E expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrNotContains(e), message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds) {
        this.verifyEmptyOrNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, String message, Object ... params) {
        this.verifyEmptyOrNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).emptyOrNotContains(e), waitInSeconds, intervalInMilliSeconds, "Is Empty Or Not Contains The Record");
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrNotContains(e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Iterable<E> expected) {
        this.verifyEquals(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Iterable<E> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, true, (A a, B e) -> {
            CList diffActual = new CList();
            CList diffExpected = new CList();
            boolean result = this._toState(a).isEqual(expected, e1 -> diffActual.add(e1), e1 -> diffExpected.add(e1));
            if (!diffExpected.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diffExpected, new Object[0]);
            }
            if (!diffActual.isEmpty()) {
                verificationQueue.getLogger().trace("Expected list does not contain following records:\n" + diffActual, new Object[0]);
            }
            return result;
        }, message, params);
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds) {
        this.verifyEquals(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyEquals(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, true, (a, e) -> {
            CList diffActual = new CList();
            CList diffExpected = new CList();
            boolean result = this._toState(a).isEqual(expected, e1 -> diffActual.add(e1), e1 -> diffExpected.add(e1));
            if (!diffExpected.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diffExpected, new Object[0]);
            }
            if (!diffActual.isEmpty()) {
                verificationQueue.getLogger().trace("Expected list does not contain following records:\n" + diffActual, new Object[0]);
            }
            return result;
        }, waitInSeconds, intervalInMilliSeconds, "Records Are Equals");
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, true, (A a, B e) -> {
            CList diffActual = new CList();
            CList diffExpected = new CList();
            boolean result = this._toState(a).isEqual(expected, e1 -> diffActual.add(e1), e1 -> diffExpected.add(e1));
            if (!diffExpected.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diffExpected, new Object[0]);
            }
            if (!diffActual.isEmpty()) {
                verificationQueue.getLogger().trace("Expected list does not contain following records:\n" + diffActual, new Object[0]);
            }
            return result;
        }, waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyHas(CVerificationQueue verificationQueue, Predicate<E> expected) {
        this.verifyHas(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyHas(CVerificationQueue verificationQueue, Predicate<E> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> CIterableUtil.has((Iterable)this.getBaseValue(), e), message, params);
    }

    default public void verifyHas(CVerificationQueue verificationQueue, Predicate<E> expected, int waitInSeconds) {
        this.verifyHas(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyHas(CVerificationQueue verificationQueue, Predicate<E> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyHas(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyHas(CVerificationQueue verificationQueue, Predicate<E> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> CIterableUtil.has((Iterable)this.getBaseValue(), e), waitInSeconds, intervalInMilliSeconds, "Has The Record With Defined Condition");
    }

    default public void verifyHas(CVerificationQueue verificationQueue, Predicate<E> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> CIterableUtil.has((Iterable)this.getBaseValue(), e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue) {
        this.verifyIsEmpty(verificationQueue, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A a, B e) -> CIterableUtil.isEmpty((Iterable)this.getBaseValue()), message, params);
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds) {
        this.verifyIsEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds, String message, Object ... params) {
        this.verifyIsEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, true, false, (a, e) -> CIterableUtil.isEmpty((Iterable)this.getBaseValue()), waitInSeconds, intervalInMilliSeconds, "Is Empty");
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A a, B e) -> CIterableUtil.isEmpty((Iterable)this.getBaseValue()), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue) {
        this.verifyIsNotEmpty(verificationQueue, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A a, B e) -> !CIterableUtil.isEmpty((Iterable)this.getBaseValue()), message, params);
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds) {
        this.verifyIsNotEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds, String message, Object ... params) {
        this.verifyIsNotEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, true, false, (a, e) -> !CIterableUtil.isEmpty((Iterable)this.getBaseValue()), waitInSeconds, intervalInMilliSeconds, "Is Not Empty");
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A a, B e) -> !CIterableUtil.isEmpty((Iterable)this.getBaseValue()), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, E expected) {
        this.verifyNotContains(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, E expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).notContains(e), message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds) {
        this.verifyNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, String message, Object ... params) {
        this.verifyNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).notContains(e), waitInSeconds, intervalInMilliSeconds, "Does Not Contains The Record");
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, E expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).notContains(e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected) {
        this.verifyNotContainsAll(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).notContainsAll(expected), message, params);
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds) {
        this.verifyNotContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyNotContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).notContainsAll(expected), waitInSeconds, intervalInMilliSeconds, "Does Not Contains All Records");
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Iterable<E> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).notContainsAll(expected), waitInSeconds, intervalInMilliSeconds, message, params);
    }
}

