/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.verify.interfaces;

import java.util.Map;
import java.util.Objects;
import org.catools.common.collections.CHashMap;
import org.catools.common.extensions.states.interfaces.CMapState;
import org.catools.common.extensions.verify.CVerificationQueue;
import org.catools.common.extensions.verify.interfaces.CObjectVerifier;
import org.catools.common.text.CStringUtil;

public interface CMapVerifier<K, V>
extends CObjectVerifier<Map<K, V>, CMapState<K, V>> {
    @Override
    default public CMapState<K, V> _toState(Object e) {
        return () -> (Map)e;
    }

    default public void verifyContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue) {
        this.verifyContains(verificationQueue, Map.entry(expectedKey, expectedValue));
    }

    default public void verifyContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, String message, Object ... params) {
        this.verifyContains(verificationQueue, Map.entry(expectedKey, expectedValue), message, params);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected) {
        this.verifyContains(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).contains(e), message, params);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds) {
        this.verifyContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, String message, Object ... params) {
        this.verifyContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds) {
        this.verifyContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds) {
        this.verifyContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this.verifyContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).contains(e), waitInSeconds, intervalInMilliSeconds, "Contains The Expected Value");
    }

    default public void verifyContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).contains(e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected) {
        this.verifyContainsAll(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            if (expected == null) {
                return false;
            }
            CHashMap diff = new CHashMap();
            boolean result = this._toState(a).containsAll(e, entry -> diff.put(entry.getKey(), entry.getValue()));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diff, new Object[0]);
            }
            return result;
        }, message, params);
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds) {
        this.verifyContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> {
            if (expected == null) {
                return false;
            }
            CHashMap diff = new CHashMap();
            boolean result = this._toState(a).containsAll(e, entry -> diff.put(entry.getKey(), entry.getValue()));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diff, new Object[0]);
            }
            return result;
        }, waitInSeconds, intervalInMilliSeconds, "Contains All Records From The Expected Map");
    }

    default public void verifyContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            if (expected == null) {
                return false;
            }
            CHashMap diff = new CHashMap();
            boolean result = this._toState(a).containsAll(e, entry -> diff.put(entry.getKey(), entry.getValue()));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diff, new Object[0]);
            }
            return result;
        }, waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Map<K, V> expected) {
        this.verifyContainsNone(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Map<K, V> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            if (expected == null) {
                return false;
            }
            CHashMap diff = new CHashMap();
            boolean result = this._toState(a).containsNone(e, entry -> diff.put(entry.getKey(), entry.getValue()));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list contains following records:\n" + diff, new Object[0]);
            }
            return result;
        }, message, params);
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds) {
        this.verifyContainsNone(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyContainsNone(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> {
            if (expected == null) {
                return false;
            }
            CHashMap diff = new CHashMap();
            boolean result = this._toState(a).containsNone(e, entry -> diff.put(entry.getKey(), entry.getValue()));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list contains following records:\n" + diff, new Object[0]);
            }
            return result;
        }, waitInSeconds, intervalInMilliSeconds, "Not Contains Any Record From The Expected Map");
    }

    default public void verifyContainsNone(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> {
            if (expected == null) {
                return false;
            }
            CHashMap diff = new CHashMap();
            boolean result = this._toState(a).containsNone(e, entry -> diff.put(entry.getKey(), entry.getValue()));
            if (!diff.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list contains following records:\n" + diff, new Object[0]);
            }
            return result;
        }, waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue) {
        this.verifyEmptyOrContains(verificationQueue, Map.entry(expectedKey, expectedValue));
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, String message, Object ... params) {
        this.verifyEmptyOrContains(verificationQueue, Map.entry(expectedKey, expectedValue), message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected) {
        Objects.requireNonNull(expected.getKey());
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrContains(e), "Is Empty Or Contains The Expected Value", new Object[0]);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, String message, Object ... params) {
        Objects.requireNonNull(expected.getKey());
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrContains(e), message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds) {
        this.verifyEmptyOrContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, String message, Object ... params) {
        this.verifyEmptyOrContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds) {
        Objects.requireNonNull(expected.getKey());
        this.verifyEmptyOrContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, String message, Object ... params) {
        Objects.requireNonNull(expected.getKey());
        this.verifyEmptyOrContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds) {
        this.verifyEmptyOrContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this.verifyEmptyOrContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        Objects.requireNonNull(expected.getKey());
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).emptyOrContains(e), waitInSeconds, intervalInMilliSeconds, "Is Empty Or Contains The Expected Value");
    }

    default public void verifyEmptyOrContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        Objects.requireNonNull(expected.getKey());
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrContains(e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue) {
        this.verifyEmptyOrNotContains(verificationQueue, Map.entry(expectedKey, expectedValue));
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, String message, Object ... params) {
        this.verifyEmptyOrNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected) {
        this.verifyEmptyOrNotContains(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, String message, Object ... params) {
        Objects.requireNonNull(expected.getKey());
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrNotContains(expected), message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds) {
        this.verifyEmptyOrNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, String message, Object ... params) {
        this.verifyEmptyOrNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds) {
        Objects.requireNonNull(expected.getKey());
        this.verifyEmptyOrNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, String message, Object ... params) {
        Objects.requireNonNull(expected.getKey());
        this.verifyEmptyOrNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds) {
        this.verifyEmptyOrNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this.verifyEmptyOrNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        Objects.requireNonNull(expected.getKey());
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).emptyOrNotContains(expected), waitInSeconds, intervalInMilliSeconds, "Is Empty Or Not Contains The Expected Value");
    }

    default public void verifyEmptyOrNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        Objects.requireNonNull(expected.getKey());
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).emptyOrNotContains(expected), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Map<K, V> expected) {
        this.verifyEquals(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Map<K, V> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> {
            CHashMap diffActual = new CHashMap();
            CHashMap diffExpected = new CHashMap();
            boolean equals = this._toState(o).isEqual(o2, entry -> diffActual.put(entry.getKey(), entry.getValue()), entry -> diffExpected.put(entry.getKey(), entry.getValue()));
            if (!diffExpected.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diffExpected, new Object[0]);
            }
            if (!diffActual.isEmpty()) {
                verificationQueue.getLogger().trace("Expected list does not contain following records:\n" + diffActual, new Object[0]);
            }
            return equals;
        }, CStringUtil.format(message, params), new Object[0]);
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds) {
        this.verifyEquals(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyEquals(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> {
            CHashMap diffActual = new CHashMap();
            CHashMap diffExpected = new CHashMap();
            boolean equals = this._toState(o).isEqual(o2, entry -> diffActual.put(entry.getKey(), entry.getValue()), entry -> diffExpected.put(entry.getKey(), entry.getValue()));
            if (!diffExpected.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diffExpected, new Object[0]);
            }
            if (!diffActual.isEmpty()) {
                verificationQueue.getLogger().trace("Expected list does not contain following records:\n" + diffActual, new Object[0]);
            }
            return equals;
        }, waitInSeconds, intervalInMilliSeconds, "Equals Expected Value");
    }

    @Override
    default public void verifyEquals(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> {
            CHashMap diffActual = new CHashMap();
            CHashMap diffExpected = new CHashMap();
            boolean equals = this._toState(o).isEqual(o2, entry -> diffActual.put(entry.getKey(), entry.getValue()), entry -> diffExpected.put(entry.getKey(), entry.getValue()));
            if (!diffExpected.isEmpty()) {
                verificationQueue.getLogger().trace("Actual list does not contain following records:\n" + diffExpected, new Object[0]);
            }
            if (!diffActual.isEmpty()) {
                verificationQueue.getLogger().trace("Expected list does not contain following records:\n" + diffActual, new Object[0]);
            }
            return equals;
        }, waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue) {
        this.verifyIsEmpty(verificationQueue, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A o, B o2) -> this.getBaseValue() == null || ((Map)this.getBaseValue()).isEmpty(), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds) {
        this.verifyIsEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds, String message, Object ... params) {
        this.verifyIsEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, true, false, (o, o2) -> this.getBaseValue() == null || ((Map)this.getBaseValue()).isEmpty(), waitInSeconds, intervalInMilliSeconds, "Is Empty");
    }

    default public void verifyIsEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A o, B o2) -> this.getBaseValue() == null || ((Map)this.getBaseValue()).isEmpty(), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue) {
        this.verifyIsNotEmpty(verificationQueue, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A o, B o2) -> this._toState(o).isNotEmpty(), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds) {
        this.verifyIsNotEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds, String message, Object ... params) {
        this.verifyIsNotEmpty(verificationQueue, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, true, false, (o, o2) -> this._toState(o).isNotEmpty(), waitInSeconds, intervalInMilliSeconds, "Is Not Empty");
    }

    default public void verifyIsNotEmpty(CVerificationQueue verificationQueue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Boolean.valueOf(true), false, (A o, B o2) -> this._toState(o).isNotEmpty(), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue) {
        this.verifyNotContains(verificationQueue, Map.entry(expectedKey, expectedValue));
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, String message, Object ... params) {
        this.verifyNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected) {
        this.verifyNotContains(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).notContains(e), message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds) {
        this.verifyNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, String message, Object ... params) {
        this.verifyNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds) {
        this.verifyNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyNotContains(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds) {
        this.verifyNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, K expectedKey, V expectedValue, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this.verifyNotContains(verificationQueue, Map.entry(expectedKey, expectedValue), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (a, e) -> this._toState(a).notContains(e), waitInSeconds, intervalInMilliSeconds, "Not Contains Expected Value");
    }

    default public void verifyNotContains(CVerificationQueue verificationQueue, Map.Entry<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A a, B e) -> this._toState(a).notContains(e), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected) {
        this.verifyNotContainsAll(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).notContainsAll(o2), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds) {
        this.verifyNotContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, String message, Object ... params) {
        this.verifyNotContainsAll(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).notContainsAll(o2), waitInSeconds, intervalInMilliSeconds, "Not Contains All Expected Values");
    }

    default public void verifyNotContainsAll(CVerificationQueue verificationQueue, Map<K, V> expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).notContainsAll(o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifySizeEquals(CVerificationQueue verificationQueue, int expected) {
        this.verifySizeEquals(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeEquals(CVerificationQueue verificationQueue, int expected, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeEquals((int)o2), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifySizeEquals(CVerificationQueue verificationQueue, int expected, int waitInSeconds) {
        this.verifySizeEquals(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeEquals(CVerificationQueue verificationQueue, int expected, int waitInSeconds, String message, Object ... params) {
        this.verifySizeEquals(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifySizeEquals(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).sizeEquals((int)o2), waitInSeconds, intervalInMilliSeconds, "Size Is Equal To Expected Value");
    }

    default public void verifySizeEquals(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeEquals((int)o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifySizeIsGreaterThan(CVerificationQueue verificationQueue, int expected) {
        this.verifySizeIsGreaterThan(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsGreaterThan(CVerificationQueue verificationQueue, int expected, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsGreaterThan((int)o2), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifySizeIsGreaterThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds) {
        this.verifySizeIsGreaterThan(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsGreaterThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds, String message, Object ... params) {
        this.verifySizeIsGreaterThan(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifySizeIsGreaterThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).sizeIsGreaterThan((int)o2), waitInSeconds, intervalInMilliSeconds, "Size Is Greater Than Expected Value");
    }

    default public void verifySizeIsGreaterThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsGreaterThan((int)o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifySizeIsGreaterThanOrEqual(CVerificationQueue verificationQueue, int expected) {
        this.verifySizeIsGreaterThanOrEqual(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsGreaterThanOrEqual(CVerificationQueue verificationQueue, int expected, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsGreaterThanOrEqual((int)o2), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifySizeIsGreaterThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds) {
        this.verifySizeIsGreaterThanOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsGreaterThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds, String message, Object ... params) {
        this.verifySizeIsGreaterThanOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifySizeIsGreaterThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).sizeIsGreaterThanOrEqual((int)o2), waitInSeconds, intervalInMilliSeconds, "Size Is Greater Than Expected Value");
    }

    default public void verifySizeIsGreaterThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsGreaterThanOrEqual((int)o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifySizeIsLessThan(CVerificationQueue verificationQueue, int expected) {
        this.verifySizeIsLessThan(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsLessThan(CVerificationQueue verificationQueue, int expected, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsLessThan((int)o2), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifySizeIsLessThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds) {
        this.verifySizeIsLessThan(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsLessThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds, String message, Object ... params) {
        this.verifySizeIsLessThan(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifySizeIsLessThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).sizeIsLessThan((int)o2), waitInSeconds, intervalInMilliSeconds, "Size Is Less Than Expected Value");
    }

    default public void verifySizeIsLessThan(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsLessThan((int)o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifySizeIsLessThanOrEqual(CVerificationQueue verificationQueue, int expected) {
        this.verifySizeIsLessThanOrEqual(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsLessThanOrEqual(CVerificationQueue verificationQueue, int expected, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsLessThanOrEqual((int)o2), CStringUtil.format(message, params), new Object[0]);
    }

    default public void verifySizeIsLessThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds) {
        this.verifySizeIsLessThanOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsLessThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds, String message, Object ... params) {
        this.verifySizeIsLessThanOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifySizeIsLessThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds) {
        this.verifySizeIsLessThanOrEqual(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifySizeIsLessThanOrEqual(CVerificationQueue verificationQueue, int expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, Integer.valueOf(expected), false, (A o, B o2) -> this._toState(o).sizeIsLessThanOrEqual((int)o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }
}

