/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.verify.interfaces;

import org.catools.common.collections.CHashMap;
import org.catools.common.extensions.states.interfaces.CNumberState;
import org.catools.common.extensions.verify.CVerificationQueue;
import org.catools.common.extensions.verify.interfaces.CObjectVerifier;

public interface CNumberVerifier<N extends Number>
extends CObjectVerifier<N, CNumberState<N>> {
    @Override
    default public CNumberState<N> _toState(Object e) {
        return () -> (Number)e;
    }

    default public void verifyBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound) {
        this.verifyBetweenExclusive(verificationQueue, lowerBound, higherBound, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).betweenExclusive(lowerBound, higherBound), message, params);
    }

    default public void verifyBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds) {
        this.verifyBetweenExclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, String message, Object ... params) {
        this.verifyBetweenExclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verifyWithDefaultMessage(verificationQueue, map, false, (o, o2) -> this._toState(o).betweenExclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, String.format("Is Between %s And %s (Exclusive)", lowerBound, higherBound));
    }

    default public void verifyBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).betweenExclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound) {
        this.verifyBetweenInclusive(verificationQueue, lowerBound, higherBound, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).betweenInclusive(lowerBound, higherBound), message, params);
    }

    default public void verifyBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds) {
        this.verifyBetweenInclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, String message, Object ... params) {
        this.verifyBetweenInclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verifyWithDefaultMessage(verificationQueue, map, false, (o, o2) -> this._toState(o).betweenInclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, String.format("Is Between %s And %s (Inclusive)", lowerBound, higherBound));
    }

    default public void verifyBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).betweenInclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyEqualsP(CVerificationQueue verificationQueue, N expected, N precision) {
        this.verifyEqualsP(verificationQueue, expected, precision, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEqualsP(CVerificationQueue verificationQueue, N expected, N precision, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).isEqual(expected, precision), "[precision: " + precision + "]" + message, params);
    }

    default public void verifyEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds) {
        this.verifyEqualsP(verificationQueue, expected, precision, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds, String message, Object ... params) {
        this.verifyEqualsP(verificationQueue, expected, precision, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).isEqual(expected, precision), waitInSeconds, intervalInMilliSeconds, String.format("Is Equal To The Expected Value (with precision %s)", precision));
    }

    default public void verifyEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).isEqual(expected, precision), waitInSeconds, intervalInMilliSeconds, "[precision: " + precision + "]" + message, params);
    }

    default public void verifyGreater(CVerificationQueue verificationQueue, N expected) {
        this.verifyGreater(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyGreater(CVerificationQueue verificationQueue, N expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).greater(o2), message, params);
    }

    default public void verifyGreater(CVerificationQueue verificationQueue, N expected, int waitInSeconds) {
        this.verifyGreater(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyGreater(CVerificationQueue verificationQueue, N expected, int waitInSeconds, String message, Object ... params) {
        this.verifyGreater(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyGreater(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).greater(o2), waitInSeconds, intervalInMilliSeconds, "Is Greater Than The Expected Value");
    }

    default public void verifyGreater(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).greater(o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyGreaterOrEqual(CVerificationQueue verificationQueue, N expected) {
        this.verifyGreaterOrEqual(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyGreaterOrEqual(CVerificationQueue verificationQueue, N expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).greaterOrEqual(o2), message, params);
    }

    default public void verifyGreaterOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds) {
        this.verifyGreaterOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyGreaterOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds, String message, Object ... params) {
        this.verifyGreaterOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyGreaterOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).greaterOrEqual(o2), waitInSeconds, intervalInMilliSeconds, "Is Greater Than Or Equal To The Expected Value");
    }

    default public void verifyGreaterOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).greaterOrEqual(o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyLess(CVerificationQueue verificationQueue, N expected) {
        this.verifyLess(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyLess(CVerificationQueue verificationQueue, N expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).less(o2), message, params);
    }

    default public void verifyLess(CVerificationQueue verificationQueue, N expected, int waitInSeconds) {
        this.verifyLess(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyLess(CVerificationQueue verificationQueue, N expected, int waitInSeconds, String message, Object ... params) {
        this.verifyLess(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyLess(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).less(o2), waitInSeconds, intervalInMilliSeconds, "Is Less Than The Expected Value");
    }

    default public void verifyLess(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).less(o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyLessOrEqual(CVerificationQueue verificationQueue, N expected) {
        this.verifyLessOrEqual(verificationQueue, expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyLessOrEqual(CVerificationQueue verificationQueue, N expected, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).lessOrEqual(o2), message, params);
    }

    default public void verifyLessOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds) {
        this.verifyLessOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyLessOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds, String message, Object ... params) {
        this.verifyLessOrEqual(verificationQueue, expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyLessOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).lessOrEqual(o2), waitInSeconds, intervalInMilliSeconds, "Is Less Than Or Equal To The Expected Value");
    }

    default public void verifyLessOrEqual(CVerificationQueue verificationQueue, N expected, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).lessOrEqual(o2), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound) {
        this.verifyNotBetweenExclusive(verificationQueue, lowerBound, higherBound, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).notBetweenExclusive(lowerBound, higherBound), message, params);
    }

    default public void verifyNotBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds) {
        this.verifyNotBetweenExclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, String message, Object ... params) {
        this.verifyNotBetweenExclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verifyWithDefaultMessage(verificationQueue, map, false, (o, o2) -> this._toState(o).notBetweenExclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, String.format("Not Is Between %s And %s (Exclusive)", lowerBound, higherBound));
    }

    default public void verifyNotBetweenExclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).notBetweenExclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound) {
        this.verifyNotBetweenInclusive(verificationQueue, lowerBound, higherBound, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).notBetweenInclusive(lowerBound, higherBound), message, params);
    }

    default public void verifyNotBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds) {
        this.verifyNotBetweenInclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, String message, Object ... params) {
        this.verifyNotBetweenInclusive(verificationQueue, lowerBound, higherBound, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verifyWithDefaultMessage(verificationQueue, map, false, (o, o2) -> this._toState(o).notBetweenInclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, String.format("Not Is Between %s And %s (Inclusive)", lowerBound, higherBound));
    }

    default public void verifyNotBetweenInclusive(CVerificationQueue verificationQueue, N lowerBound, N higherBound, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        CHashMap<String, N> map = new CHashMap<String, N>();
        map.put("LB", lowerBound);
        map.put("HB", higherBound);
        this._verify(verificationQueue, map, false, (A o, B o2) -> this._toState(o).notBetweenInclusive(lowerBound, higherBound), waitInSeconds, intervalInMilliSeconds, message, params);
    }

    default public void verifyNotEqualsP(CVerificationQueue verificationQueue, N expected, N precision) {
        this.verifyNotEqualsP(verificationQueue, expected, precision, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotEqualsP(CVerificationQueue verificationQueue, N expected, N precision, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).notEquals(o2, precision), "[precision: " + precision + "]" + message, params);
    }

    default public void verifyNotEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds) {
        this.verifyNotEqualsP(verificationQueue, expected, precision, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public void verifyNotEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds, String message, Object ... params) {
        this.verifyNotEqualsP(verificationQueue, expected, precision, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds(), message, params);
    }

    default public void verifyNotEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds, int intervalInMilliSeconds) {
        this._verifyWithDefaultMessage(verificationQueue, expected, false, (o, o2) -> this._toState(o).notEquals(o2, precision), waitInSeconds, intervalInMilliSeconds, String.format("Is Not Equal To The Expected Value (with precision %s)", precision));
    }

    default public void verifyNotEqualsP(CVerificationQueue verificationQueue, N expected, N precision, int waitInSeconds, int intervalInMilliSeconds, String message, Object ... params) {
        this._verify(verificationQueue, expected, false, (A o, B o2) -> this._toState(o).notEquals(o2, precision), waitInSeconds, intervalInMilliSeconds, "[precision: " + precision + "]" + message, params);
    }
}

