/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.wait.interfaces;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.catools.common.concurrent.CSleeper;
import org.catools.common.date.CDate;
import org.catools.common.extensions.states.interfaces.CObjectState;
import org.catools.common.extensions.wait.interfaces.CBaseWaiter;

public interface CObjectWaiter<O>
extends CBaseWaiter<O> {
    default public boolean wait(Predicate<O> predicate) {
        return this.wait(predicate, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean wait(Predicate<O> predicate, int waitInSeconds) {
        return this.wait(predicate, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean wait(Predicate<O> predicate, int waitInSeconds, int intervalInMilliSeconds) {
        return this._waiter(o -> this.toState(o).test(predicate), waitInSeconds, intervalInMilliSeconds);
    }

    default public boolean waitIsNull() {
        return this.waitIsNull(this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitIsNull(int waitInSeconds) {
        return this.waitIsNull(waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitIsNull(int waitInSeconds, int intervalInMilliSeconds) {
        return this._waiter(o -> o == null, waitInSeconds, intervalInMilliSeconds);
    }

    default public boolean waitIsNotNull() {
        return this.waitIsNotNull(this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitIsNotNull(int waitInSeconds) {
        return this.waitIsNotNull(waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitIsNotNull(int waitInSeconds, int intervalInMilliSeconds) {
        return this._waiter(o -> o != null, waitInSeconds, intervalInMilliSeconds);
    }

    default public boolean waitEquals(O expected) {
        return this.waitEquals(expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitEquals(O expected, int waitInSeconds) {
        return this.waitEquals(expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitEquals(O expected, int waitInSeconds, int intervalInMilliSeconds) {
        return this._waiter(o -> Objects.equals(o, expected), waitInSeconds, intervalInMilliSeconds);
    }

    default public boolean waitNotEquals(O expected) {
        return this.waitNotEquals(expected, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitNotEquals(O expected, int waitInSeconds) {
        return this.waitNotEquals(expected, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitNotEquals(O expected, int waitInSeconds, int intervalInMilliSeconds) {
        return this._waiter(o -> !Objects.equals(o, expected), waitInSeconds, intervalInMilliSeconds);
    }

    default public boolean waitEqualsAny(List<O> expectedList) {
        return this.waitEqualsAny(expectedList, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitEqualsAny(List<O> expectedList, int waitInSeconds) {
        return this.waitEqualsAny(expectedList, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitEqualsAny(List<O> expectedList, int waitInSeconds, int intervalInMilliSeconds) {
        return this._waiter(a -> this.toState(a).equalsAny((Iterable<Object>)expectedList), waitInSeconds, intervalInMilliSeconds);
    }

    default public boolean waitEqualsNone(List<O> expectedList) {
        return this.waitEqualsNone(expectedList, this.getDefaultWaitInSeconds(), this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitEqualsNone(List<O> expectedList, int waitInSeconds) {
        return this.waitEqualsNone(expectedList, waitInSeconds, this.getDefaultWaitIntervalInMilliSeconds());
    }

    default public boolean waitEqualsNone(List<O> expectedList, int waitInSeconds, int intervalInMilliSeconds) {
        return this._waiter(a -> this.toState(a).equalsNone((Iterable<Object>)expectedList), waitInSeconds, intervalInMilliSeconds);
    }

    default public boolean _waiter(Predicate<O> waitMethod, int waitInSeconds, int intervalInMilliSeconds) {
        boolean isTimeOuted = false;
        Throwable lastException = null;
        CDate deadLine = new CDate().addSeconds(waitInSeconds);
        while (true) {
            try {
                if (waitMethod.test(this.getBaseValue())) {
                    break;
                }
            }
            catch (Throwable t) {
                lastException = t;
            }
            if (deadLine.before(CDate.now())) {
                isTimeOuted = true;
                break;
            }
            if (waitInSeconds * 1000 <= intervalInMilliSeconds) continue;
            CSleeper.sleepTight(intervalInMilliSeconds);
        }
        if (isTimeOuted && lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new RuntimeException(lastException);
        }
        return !isTimeOuted;
    }

    private CObjectState<O> toState(final O e) {
        return new CObjectState(){

            public boolean isEqual(Object expected) {
                return Objects.equals(this.getBaseValue(), expected);
            }

            @Override
            public Object getBaseValue() {
                return e;
            }
        };
    }
}

