/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.function.Function;
import org.catools.common.config.CConfigInfo;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CAnsiColor;
import org.catools.common.security.CSecurityManager;
import org.catools.common.text.CStringUtil;
import org.fusesource.jansi.AnsiConsole;

public class CConsole {
    public static synchronized String print(String input, Object ... params) {
        return CConsole.print(CStringUtil.format(input, params));
    }

    public static synchronized String println(String input, Object ... params) {
        return CConsole.print(CStringUtil.format(input, params) + System.lineSeparator());
    }

    public static synchronized String print(String input) {
        String output = CSecurityManager.mask(input);
        if (CConfigs.System.isConsoleAvailable()) {
            AnsiConsole.out().print(output);
            AnsiConsole.out().flush();
        } else {
            AnsiConsole.system_out.print(output);
            AnsiConsole.system_out.flush();
        }
        return output;
    }

    public static void printBlue(String input, Object ... params) {
        CConsole.print(CAnsiColor.toBlue(input, params));
    }

    public static void printCyan(String input, Object ... params) {
        CConsole.print(CAnsiColor.toCyan(input, params));
    }

    public static void printGreen(String input, Object ... params) {
        CConsole.print(CAnsiColor.toGreen(input, params));
    }

    public static void printMagenta(String input, Object ... params) {
        CConsole.print(CAnsiColor.toMagenta(input, params));
    }

    public static void printRed(String input, Object ... params) {
        CConsole.print(CAnsiColor.toRed(input, params));
    }

    public static void printYellow(String input, Object ... params) {
        CConsole.print(CAnsiColor.toYellow(input, params));
    }

    public static String prompt(CConfigInfo parameter) {
        return CConsole.prompt((String)CStringUtil.defaultIfBlank((CharSequence)parameter.getDescription(), (CharSequence)parameter.getName()), parameter.getDefaultValue(), parameter.isSensitive());
    }

    public static String prompt(String message, String defaultReturnValue, boolean isSensitive) {
        if (CStringUtil.isBlank((CharSequence)defaultReturnValue)) {
            CConsole.print(message + ": ");
        } else {
            CConsole.print("%s [%s]: ", message, defaultReturnValue);
        }
        if (isSensitive && CConfigs.Security.shouldMaskSensitiveInfo() && CConfigs.System.isConsoleAvailable()) {
            return (String)CStringUtil.defaultIfBlank((CharSequence)CConsole.readPassword(), (CharSequence)defaultReturnValue);
        }
        return (String)CStringUtil.defaultIfBlank((CharSequence)CConsole.readLine(), (CharSequence)defaultReturnValue);
    }

    public static String prompt(String input, Object ... params) {
        return CConsole.prompt(CStringUtil.format(input, params), "", false);
    }

    public static <T> T readInput(String prompt, Function<String, T> verifier) {
        String input;
        T apply;
        HashSet output = new HashSet();
        do {
            input = CConsole.prompt(prompt, new Object[0]);
            output.clear();
        } while ((apply = verifier.apply(input)) == null);
        return apply;
    }

    public static void pressEnterToContinue(String message) {
        CConsole.println(message, new Object[0]);
        CConsole.pressEnterToContinue();
    }

    public static void pressEnterToContinue() {
        CConsole.readKey("Press enter to continue...");
    }

    public static String readKey(String message) {
        return CConsole.prompt(message, "", false);
    }

    private static synchronized String readLine() {
        try {
            return new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read console input.", e);
        }
    }

    private static synchronized String readPassword() {
        return new String(System.console().readPassword("", new Object[0]));
    }
}

