/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;
import org.catools.common.executor.CRetry;
import org.catools.common.extensions.types.interfaces.CFileExtension;
import org.catools.common.io.CFileNotFoundException;
import org.catools.common.io.CFileOperationException;
import org.catools.common.io.CFileUtil;
import org.catools.common.io.CStreamUtil;
import org.catools.common.json.CJsonUtil;
import org.catools.common.text.CRegExUtil;

public class CFile
extends File
implements CFileExtension {
    public CFile(File file) {
        this(file.toURI());
    }

    public CFile(String pathname) {
        super(pathname);
    }

    public CFile(String parent, String child) {
        super(parent, child);
    }

    public CFile(File parent, String child) {
        super(parent, child);
    }

    public CFile(URI uri) {
        super(uri);
    }

    public static CFile fromRemote(String ip, File parent, String child) {
        return CFile.fromRemote(ip, new CFile(parent, child));
    }

    public static CFile fromRemote(String ip, String fullName) {
        return CFile.fromRemote(ip, new CFile(fullName));
    }

    public static CFile fromRemote(String ip, CFile path) {
        return CRetry.retry(integer -> {
            CFile file = new CFile(String.format("\\\\%s\\%s", ip, path.getCanonicalPath().replaceFirst(":", "\\$")));
            if (!file.exists()) {
                throw new RuntimeException("The destination file not found after copy:" + file);
            }
            return file;
        }, 1, 2000, null);
    }

    public static CFile fromURL(URL url, File parent, String child) {
        return CFile.fromURL(url, new CFile(parent, child));
    }

    public static CFile fromURL(URL url, String fullName) {
        return CFile.fromURL(url, new CFile(fullName));
    }

    public static CFile fromURL(URL url, CFile destination) {
        return CRetry.retry(integer -> {
            try {
                FileUtils.copyURLToFile((URL)url, (File)destination);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!destination.exists()) {
                throw new RuntimeException("The destination file not found after copy:" + destination);
            }
            return destination;
        }, 1, 2000, null);
    }

    public static CFile fromCurrent(String child) {
        return new CFile(".", child);
    }

    public static CFile fromOutput(String child) {
        return new CFile(CConfigs.Path.getOutputPath(), child);
    }

    public static CFile fromStorage(String child) {
        return new CFile(CConfigs.Path.getStorageFolder(), child);
    }

    public static CFile fromTmp(String child) {
        return new CFile(CConfigs.Path.getTempFolder(), child);
    }

    public CFile append(String content) {
        return this.append(content, Charset.defaultCharset());
    }

    public CFile append(String content, Charset charset) {
        try {
            this.getParentFile().mkdirs();
            FileUtils.writeStringToFile((File)this, (String)content, (Charset)charset, (boolean)true);
            return this;
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to write to the file.", e);
        }
    }

    public CFile append(byte[] content) {
        try {
            this.getParentFile().mkdirs();
            FileUtils.writeByteArrayToFile((File)this, (byte[])content, (boolean)true);
            return this;
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to write to the file.", e);
        }
    }

    public CFile copy(File destFile) {
        if (this.isDirectory()) {
            try {
                FileUtils.copyDirectory((File)this, (File)destFile);
            }
            catch (Throwable t) {
                throw new CFileOperationException(this, "Failed to copy the file to destination file: " + destFile.getAbsolutePath());
            }
        } else {
            this.copyFile(destFile);
        }
        return new CFile(destFile);
    }

    public CFile copyFile(File destFile) {
        try {
            this.getParentFile().mkdirs();
            FileUtils.copyFile((File)this, (File)destFile);
            return new CFile(destFile);
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to copy file to " + destFile, e);
        }
    }

    @Override
    public boolean createNewFile() {
        try {
            return super.createNewFile();
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to create the file.", e);
        }
    }

    @Override
    public boolean delete() {
        try {
            if (this.isDirectory()) {
                CFileUtil.cleanDirectory((File)this);
            }
            return super.delete();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public CFile forceDelete() {
        CRetry.retryIf(c -> {
            try {
                FileUtils.forceDelete((File)this);
                return this;
            }
            catch (Throwable e) {
                throw new CFileOperationException(this, "Failed to delete file.", e);
            }
        }, cFile -> cFile.exists(), 3, 1000, null);
        return this;
    }

    public boolean forceMkdirs() {
        this.delete();
        return super.mkdirs();
    }

    @Override
    public CFile getCanonicalFile() {
        try {
            return new CFile(super.getCanonicalFile());
        }
        catch (Throwable t) {
            throw new CFileOperationException(this, "Failed to get the Canonical path as file to the file", t);
        }
    }

    @Override
    public String getCanonicalPath() {
        try {
            return super.getCanonicalPath();
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to get the Canonical path to the file", e);
        }
    }

    public CFile getChildFile(String filename) {
        this.mkdirs();
        return new CFile(this, filename);
    }

    public CFile getChildFolder(String filename) {
        CFile cFile = new CFile(this, filename);
        cFile.mkdirs();
        return cFile;
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this);
        }
        catch (Throwable t) {
            throw new CFileNotFoundException(this, t);
        }
    }

    @Override
    public CFile getParentFile() {
        return new CFile(super.getParentFile());
    }

    public CFile moveTo(File dest) {
        this.copyFile(dest);
        this.forceDelete();
        return new CFile(dest);
    }

    public CList<String> readLines() {
        return this.readLines(Charset.defaultCharset());
    }

    public CList<String> readLines(Charset charset) {
        try {
            return new CList<String>((Iterable<String>)Files.readAllLines(this.toPath(), charset));
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to read lines from the file.", e);
        }
    }

    public String readString() {
        return this.readString(Charset.defaultCharset());
    }

    public String readString(Charset charset) {
        try {
            return Files.readString(this.toPath(), charset);
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to read from the file.", e);
        }
    }

    public CFile safeRename(File destFile, boolean overwrite) {
        if (destFile.exists()) {
            if (overwrite) {
                if (!destFile.delete()) {
                    throw new CFileOperationException(this, "Failed to delete the destination file before rename it. destination file: " + destFile.getAbsolutePath());
                }
            } else {
                return this;
            }
        }
        return this.moveTo(destFile);
    }

    public boolean waitForWritable(int timeoutInSeconds) {
        return this.waitForWritable(timeoutInSeconds, 100);
    }

    public boolean waitForWritable(int timeoutInSeconds, int intervalInMillSeconds) {
        int retryCount = timeoutInSeconds * 1000 / intervalInMillSeconds;
        return CRetry.retryIfFalse(integer -> this.exists() && this.canWrite(), retryCount, intervalInMillSeconds, () -> false, false);
    }

    public boolean waitToExists(int timeoutInSeconds) {
        return this.waitToExists(timeoutInSeconds, 100);
    }

    public boolean waitToExists(int timeoutInSeconds, int intervalInMillSeconds) {
        int retryCount = timeoutInSeconds * 1000 / intervalInMillSeconds;
        return CRetry.retryIfFalse(integer -> this.exists(), retryCount, intervalInMillSeconds, null, false);
    }

    public CFile writeJson(Object object) {
        return this.writeJson(object, Charset.defaultCharset());
    }

    public CFile writeJson(Object object, Charset charset) {
        return this.write(CJsonUtil.toString(object), charset);
    }

    public CFile write(String content) {
        return this.write(content, Charset.defaultCharset());
    }

    public CFile write(String content, Charset charset) {
        try {
            this.getParentFile().mkdirs();
            FileUtils.writeStringToFile((File)this, (String)content, (Charset)charset);
            return this;
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to write to the file.", e);
        }
    }

    public CFile write(byte[] content) {
        try {
            this.getParentFile().mkdirs();
            FileUtils.writeByteArrayToFile((File)this, (byte[])content);
            return this;
        }
        catch (Throwable e) {
            throw new CFileOperationException(this, "Failed to write to the file.", e);
        }
    }

    public CFile write(InputStream inputStream) {
        return this.write(CStreamUtil.toByteArray(inputStream));
    }

    public byte[] toByteArray() {
        try {
            return IOUtils.toByteArray((InputStream)this.getInputStream());
        }
        catch (IOException e) {
            throw new CFileOperationException(this, "Failed to read file", e);
        }
    }

    public boolean notExist() {
        return !this.exists();
    }

    public CFile copyToRemoteFolder(String remoteIP, File destFolder) {
        try {
            CFile remoteFolder = new CFile(CFile.getRemoteFileName(remoteIP, destFolder));
            remoteFolder.mkdirs();
            CFile destFile = new CFile(remoteFolder, this.getName());
            CFileUtil.copyFile((File)this, (File)destFile);
            return destFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CFile copyFromRemoteFolder(String remoteIP, File destFolder) {
        try {
            CFile remoteFolder = new CFile(CFile.getRemoteFileName(remoteIP, destFolder));
            remoteFolder.mkdirs();
            CFile destFile = new CFile(remoteFolder, this.getName());
            CFileUtil.copyFile((File)destFile, (File)this);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getRemoteFileName(String remoteIP, File destFolder) {
        String root = Paths.get(new CFile(destFolder).getCanonicalPath(), new String[0]).getRoot().toString();
        String absolutePath = destFolder.getAbsolutePath();
        absolutePath = absolutePath.substring(absolutePath.lastIndexOf(root));
        return CRegExUtil.replaceAll((String)absolutePath.replace(root, "//" + remoteIP + "/" + root.replace(":", "$")), (String)"\\\\(\\.\\\\)?", (String)"/");
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public CFile getBaseValue() {
        return this;
    }

    static {
        System.setProperty("file.encoding", "UTF-8");
    }
}

