/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.io;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CFile;
import org.catools.common.io.CResourceNotFoundException;
import org.catools.common.io.CStreamUtil;
import org.catools.common.text.CStringUtil;

public class CResource {
    private String resourceFullName;
    private Class clazz;

    public CResource(String resourceFullName) {
        this(resourceFullName, null);
    }

    public CResource(String resourceFullName, @Nullable Class clazz) {
        this.resourceFullName = resourceFullName;
        this.clazz = clazz;
    }

    public boolean exists() {
        try {
            this.getInputStream();
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public InputStream getInputStream() {
        AtomicReference inputStream = new AtomicReference();
        CResource.perform(this.resourceFullName, this.clazz, (resourceName, is) -> inputStream.set(is));
        return (InputStream)inputStream.get();
    }

    public CList<String> getLines() {
        return new CList<String>(this.getString().split("\n"));
    }

    public String getResourceFullName() {
        return this.resourceFullName;
    }

    public String getResourceName() {
        if (this.resourceFullName.matches(".*(\\\\|/).*")) {
            return CStringUtil.substringAfterLast((String)this.resourceFullName.replaceAll("\\\\", "/"), (String)"/");
        }
        return this.resourceFullName;
    }

    public String getString() {
        return new String(this.getByteArray());
    }

    public byte[] getByteArray() {
        try {
            return CStreamUtil.toByteArray(this.getInputStream());
        }
        catch (Throwable t) {
            throw new CResourceNotFoundException("Failed to read resource " + this.resourceFullName, t);
        }
    }

    public CList<CFile> saveToStorage() {
        return this.saveToFolder(CConfigs.Path.getStorageFolder());
    }

    public CList<CFile> saveToOutput() {
        return this.saveToFolder(CConfigs.Path.getOutputFolder());
    }

    public CList<CFile> saveToTmp() {
        return this.saveToFolder(CConfigs.Path.getTempFolder());
    }

    public CList<CFile> saveToFolder(CFile targetFolder) {
        CList<CFile> files = new CList<CFile>();
        CResource.perform(this.resourceFullName, this.clazz, (resourceName, inputStream) -> {
            CFile destFile = new CFile(targetFolder, (String)resourceName);
            destFile.getParentFile().mkdirs();
            files.add(destFile.write((InputStream)inputStream));
        });
        return files;
    }

    private static void perform(String resourceName, Class clazz, BiConsumer<String, InputStream> consumer) {
        if (CStringUtil.isBlank((CharSequence)resourceName)) {
            throw new CResourceNotFoundException("Resource name cannot be null or empty!");
        }
        Pair<Class, ClassLoader> pair = CResource.getClassLoader(resourceName, clazz);
        if (pair == null) {
            throw new CResourceNotFoundException(resourceName + " resource not found!");
        }
        clazz = (Class)pair.getKey();
        try {
            URI uri = ((ClassLoader)pair.getValue()).getResource(resourceName).toURI();
            if (uri.getScheme().contains("jar")) {
                URL jar = clazz.getProtectionDomain().getCodeSource().getLocation();
                Path path = Paths.get(CStringUtil.substringAfter((String)jar.toString(), (String)(CConfigs.System.getPlatform().isWindows() ? "file:/" : "file:")), new String[0]);
                FileSystem fs = FileSystems.newFileSystem(path, null);
                Path resourcePath = fs.getPath(resourceName, new String[0]);
                if (Files.isDirectory(resourcePath, new LinkOption[0])) {
                    DirectoryStream<Path> directoryStream = Files.newDirectoryStream(resourcePath);
                    for (Path p : directoryStream) {
                        InputStream is = clazz.getResourceAsStream(p.toString());
                        consumer.accept(Path.of(resourceName, p.getFileName().toString()).toString(), is);
                    }
                } else {
                    JarFile jarFile = new JarFile(clazz.getProtectionDomain().getCodeSource().getLocation().getFile());
                    JarEntry jarEntry = jarFile.getJarEntry(resourceName);
                    consumer.accept(jarEntry.getName(), jarFile.getInputStream(jarFile.getEntry(resourceName)));
                }
            } else {
                Path path = Paths.get(uri);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                    for (Path p : directoryStream) {
                        consumer.accept(Path.of(resourceName, p.getFileName().toString()).toString(), new CFile(p.toFile()).getInputStream());
                    }
                } else {
                    consumer.accept(path.getFileName().toString(), new CFile(uri).getInputStream());
                }
            }
        }
        catch (Throwable t) {
            throw new CResourceNotFoundException("Unable to find " + resourceName + " resource or read it properly.");
        }
    }

    public static Pair<Class, ClassLoader> getClassLoader(String resource, Class clazz) {
        CHashMap classLoaders = new CHashMap();
        if (clazz != null) {
            classLoaders.put(clazz, clazz.getClassLoader());
            classLoaders.put(clazz.getClass(), clazz.getClass().getClassLoader());
        }
        classLoaders.put(CResource.class, CResource.class.getClassLoader());
        for (Class c : classLoaders.keySet()) {
            if (c == null || classLoaders.get(c) == null || ((ClassLoader)classLoaders.get(c)).getResource(resource) == null) continue;
            return Pair.of((Object)clazz, (Object)((ClassLoader)classLoaders.get(c)));
        }
        return null;
    }
}

