/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.IOUtils;
import org.catools.common.io.CFile;

public class CStreamUtil {
    public static String read(InputStream inputStream) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter sw = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = br.read(buffer))) {
                sw.write(buffer, 0, n);
            }
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static byte[] toByteArray(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void save(InputStream inputStream, CFile targetFile) {
        try {
            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

