/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import org.catools.common.io.CFile;
import org.catools.common.io.CFileNotFoundException;
import org.catools.common.io.CInvalidYamlContentFormatException;
import org.catools.common.io.CInvalidYamlFileFormatException;
import org.catools.common.io.CResource;
import org.catools.common.security.CCipher;

public class CYamlUtil {
    public static <T> T readFromEncryptedFile(CFile file, Class<T> clazz, String secret) {
        if (!file.exists()) {
            throw new CFileNotFoundException(file, "Property file not found");
        }
        try {
            Object t = new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(CCipher.decrypt(file.readString(), secret), clazz);
            if (t == null) {
                throw new CInvalidYamlFileFormatException(file);
            }
            return (T)t;
        }
        catch (Throwable t) {
            throw new CInvalidYamlFileFormatException(file.getPath(), t);
        }
    }

    public static <T> T readFromEncryptedResources(String fileName, Class<T> clazz, String secret) {
        return CYamlUtil.readFromEncryptedResources(fileName, clazz, clazz, secret);
    }

    public static <T> T readFromFile(CFile file, Class<T> clazz) {
        if (!file.exists()) {
            throw new CFileNotFoundException(file, "Property file not found");
        }
        try {
            Object t = new ObjectMapper((JsonFactory)new YAMLFactory()).readValue((File)file, clazz);
            if (t == null) {
                throw new CInvalidYamlFileFormatException(file);
            }
            return (T)t;
        }
        catch (Throwable t) {
            throw new CInvalidYamlFileFormatException(file.getPath(), t);
        }
    }

    public static <T> T readFromResources(String fileName, Class<T> clazz) {
        return CYamlUtil.readFromResources(fileName, clazz, clazz);
    }

    public static <T> T readFromResources(String fileName, Class classLoader, Class<T> clazz) {
        return CYamlUtil.readFromString(new CResource(fileName, classLoader).getString(), clazz);
    }

    public static <T> T readFromEncryptedResources(String fileName, Class classLoader, Class<T> clazz, String secret) {
        return CYamlUtil.readFromString(CCipher.decrypt(new CResource(fileName, classLoader).getString(), secret), clazz);
    }

    public static <T> T readFromResources(CResource resource, Class<T> clazz) {
        return CYamlUtil.readFromString(resource.getString(), clazz);
    }

    public static <T> T readFromEncryptedResources(CResource resource, Class<T> clazz, String secret) {
        return CYamlUtil.readFromString(CCipher.decrypt(resource.getString(), secret), clazz);
    }

    public static <T> T readFromString(String content, Class<T> clazz) {
        try {
            Object t = new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(content, clazz);
            if (t == null) {
                throw new CInvalidYamlContentFormatException(content);
            }
            return (T)t;
        }
        catch (Throwable t) {
            throw new CInvalidYamlContentFormatException(content, t);
        }
    }

    public static <T> void saveToEncryptedFiles(T obj, CFile file, String password) {
        try {
            String content = new ObjectMapper((JsonFactory)new YAMLFactory()).writeValueAsString(obj);
            file.write(CCipher.encrypt(content, password));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void saveToFiles(CFile file, T obj) {
        try {
            new ObjectMapper((JsonFactory)new YAMLFactory()).writeValue((File)file, obj);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

