/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.catools.common.io.CFile;
import org.catools.common.json.CInvalidJsonFormatException;
import org.catools.common.json.CJsonGenerationException;

public class CJsonUtil {
    public static <T> T clone(T object) {
        return (T)CJsonUtil.read(CJsonUtil.toString(object), object.getClass());
    }

    public static <T> T read(File file, Class<T> clazz) {
        return CJsonUtil.read(new CFile(file).readString(Charset.forName("UTF-8")), clazz);
    }

    public static <T> T read(String input, Class<T> clazz) {
        return CJsonUtil._read(input, clazz);
    }

    public static <T> T read(String wsResponseContent, TypeReference<T> typeReference) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(wsResponseContent, typeReference);
        }
        catch (Throwable t) {
            throw new CJsonGenerationException("Could not convert object to JSON string", t);
        }
    }

    public static String toString(Object object) {
        try {
            Objects.requireNonNull(object);
            return CJsonUtil.getObjectWriter().writeValueAsString(object);
        }
        catch (Throwable t) {
            throw new CJsonGenerationException("Could not convert object to JSON string", t);
        }
    }

    public static void write(File file, Object object) {
        try {
            file.getParentFile().mkdirs();
            CJsonUtil.getObjectWriter().writeValue(file, object);
        }
        catch (Throwable t) {
            throw new CJsonGenerationException("Could not write object to file as JSON", t);
        }
    }

    private static synchronized <T> T _read(String input, Class<T> clazz) {
        try {
            ObjectMapper objectMapper = CJsonUtil.getObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)objectMapper.readValue(input, clazz);
        }
        catch (IOException e) {
            throw new CInvalidJsonFormatException("Could not read json from " + input, e);
        }
    }

    private static synchronized ObjectWriter getObjectWriter() {
        ObjectMapper objectMapper = CJsonUtil.getObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return objectMapper.writerWithDefaultPrettyPrinter();
    }

    private static synchronized ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper;
    }
}

