/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.logger;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.function.BiConsumer;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigs;
import org.catools.common.date.CDate;
import org.catools.common.exception.CExceptionUtil;
import org.catools.common.io.CAnsiColor;
import org.catools.common.io.CConsole;
import org.catools.common.io.CFile;
import org.catools.common.logger.CLogLevel;
import org.catools.common.logger.CLogListener;
import org.catools.common.security.CSecurityManager;
import org.catools.common.testng.listeners.CExecutionStatisticListener;
import org.catools.common.text.CStringUtil;

public class CLogger {
    private static final CSet<CLogListener> globalListeners = new CSet();
    private final CSet<CLogListener> instanceListeners = new CSet();
    private BiConsumer<CLogLevel, String> onchange;
    private boolean logToConsole;
    private final CFile logFile;
    private int maxSysOutSize = 1024;

    public CLogger() {
        this((CFile)null, true);
    }

    public CLogger(String logFileName) {
        this(new CFile(CConfigs.Path.getLogFolder(), logFileName.replaceAll("\\W", "_") + ".log"), true);
    }

    public CLogger(String logFileName, boolean logToConsole) {
        this(new CFile(CConfigs.Path.getLogFolder(), logFileName.replaceAll("\\W", "_") + ".log"), logToConsole);
    }

    public CLogger(CFile logFile) {
        this(logFile, true);
    }

    public CLogger(CFile logFile, boolean logToConsole) {
        this.logToConsole = logToConsole;
        this.logFile = logFile;
        if (logFile != null) {
            this.logFile.getParentFile().mkdirs();
        }
    }

    public static void addGlobalListeners(CLogListener listener) {
        globalListeners.add(listener);
    }

    public static void clearGlobalListeners() {
        globalListeners.clear();
    }

    public CLogger addInstanceListeners(CLogListener listener) {
        this.instanceListeners.add(listener);
        return this;
    }

    public CLogger clearInstanceListeners() {
        this.instanceListeners.clear();
        return this;
    }

    public void fail(Object msg, Object ... params) {
        this.writeData(CLogLevel.FAIL, msg, params);
    }

    public void error(Object msg, Object ... params) {
        this.writeData(CLogLevel.ERROR, msg, params);
    }

    public void error(Throwable t) {
        this.writeData(CLogLevel.ERROR, CExceptionUtil.getMessageAndStackTrace(t), new Object[0]);
    }

    public void error(Throwable t, Object msg, Object ... params) {
        this.writeData(CLogLevel.ERROR, this.formatMessage(msg, params) + System.lineSeparator() + CExceptionUtil.getMessageAndStackTrace(t), new Object[0]);
    }

    public void warn(Object msg, Object ... params) {
        this.writeData(CLogLevel.WARN, msg, params);
    }

    public void fatal(Object msg, Object ... params) {
        this.writeData(CLogLevel.FATAL, msg, params);
    }

    public void pass(Object msg, Object ... params) {
        this.writeData(CLogLevel.PASS, msg, params);
    }

    public void info(Object msg, Object ... params) {
        this.writeData(CLogLevel.INFO, msg, params);
    }

    public void trace(Object msg, Object ... params) {
        this.writeData(CLogLevel.TRACE, msg, params);
    }

    public void time(Date start, Object msg, Object ... params) {
        this.time(start.getTime(), msg, params);
    }

    public void time(long start, Object msg, Object ... params) {
        String message = "[" + new CDate(start).toFormattedDurationToNow() + "] ::>" + msg;
        this.writeData(CLogLevel.TIME, message, params);
    }

    public void debug(Object msg, Object ... params) {
        this.writeData(CLogLevel.DEBUG, msg, params);
    }

    private String formatMessage(Object msg, Object ... params) {
        if (msg == null) {
            return "";
        }
        return params.length == 0 ? msg.toString() : CStringUtil.format(msg.toString(), params);
    }

    public BiConsumer<CLogLevel, String> getOnchange() {
        return this.onchange;
    }

    public CLogger setOnchange(BiConsumer<CLogLevel, String> onchange) {
        this.onchange = onchange;
        return this;
    }

    public boolean isLogToConsole() {
        return this.logToConsole;
    }

    public CLogger setLogToConsole(boolean logToConsole) {
        this.logToConsole = logToConsole;
        return this;
    }

    public int getMaxSysOutSize() {
        return this.maxSysOutSize;
    }

    public CLogger setMaxSysOutSize(int maxSysOutSize) {
        this.maxSysOutSize = maxSysOutSize;
        return this;
    }

    private synchronized void writeData(CLogLevel level, Object msg, Object ... params) {
        String message = CSecurityManager.mask(this.formatMessage(msg, params)) + System.lineSeparator();
        if (CStringUtil.isBlank((CharSequence)message)) {
            return;
        }
        globalListeners.forEach(l -> l.onLogging(level, message));
        this.instanceListeners.forEach(l -> l.onLogging(level, message));
        this.printToFile(level, message);
        if (this.onchange != null) {
            this.onchange.accept(level, message);
        }
        if (this.logToConsole) {
            this.printToConsole(level, message);
        }
    }

    private void printToFile(CLogLevel level, String message) {
        if (this.logFile != null && CConfigs.Logger.getFileLogLevel().getLevel() >= level.getLevel()) {
            this.logFile.append(this.getFormattedPrefix(level) + message, Charset.forName("UTF-8"));
        }
    }

    private void printToConsole(CLogLevel level, String message) {
        if (CConfigs.Logger.getConsoleLogLevel().getLevel() >= level.getLevel()) {
            if (CConfigs.Core.isReleaseModeOn() && ((String)message).length() > this.maxSysOutSize) {
                message = ((String)message).substring(0, this.maxSysOutSize) + "...\n";
            }
            String formattedPrefix = this.getFormattedPrefix(level);
            if (CConfigs.Logger.logColoredOutput()) {
                if (CLogLevel.ERROR.equals((Object)level) || CLogLevel.FAIL.equals((Object)level)) {
                    formattedPrefix = CAnsiColor.toRed(formattedPrefix, new Object[0]);
                } else if (CLogLevel.PASS.equals((Object)level)) {
                    formattedPrefix = CAnsiColor.toGreen(formattedPrefix, new Object[0]);
                } else if (CLogLevel.TIME.equals((Object)level)) {
                    formattedPrefix = CAnsiColor.toBlue(formattedPrefix, new Object[0]);
                } else if (CLogLevel.TRACE.equals((Object)level)) {
                    formattedPrefix = CAnsiColor.toCyan(formattedPrefix, new Object[0]);
                } else if (CLogLevel.DEBUG.equals((Object)level)) {
                    formattedPrefix = CAnsiColor.toYellow(formattedPrefix, new Object[0]);
                } else if (CLogLevel.WARN.equals((Object)level)) {
                    formattedPrefix = CAnsiColor.toMagenta(formattedPrefix, new Object[0]);
                }
            }
            CConsole.println(formattedPrefix + (String)message, new Object[0]);
        }
    }

    private String getFormattedPrefix(CLogLevel level) {
        if (CConfigs.Logger.logStaticInfo()) {
            return String.format("%s %s [%3s] ::> ", CExecutionStatisticListener.getStatistics(), CDate.now().toFormat("HH:mm:ss.SSS"), level.getShortName());
        }
        return String.format("%s [%3s] ::> ", CDate.now().toFormat("HH:mm:ss.SSS"), level.getShortName());
    }
}

