/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.reports;

import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import com.aventstack.extentreports.reporter.configuration.Theme;
import java.io.File;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;
import org.catools.common.logger.CLogger;
import org.catools.common.testng.model.CTestResult;
import org.catools.common.text.CStringUtil;
import org.testng.ITestResult;

public class CExtentReport
extends ExtentReports {
    private ExtentHtmlReporter extentHtmlReporter;
    private CLogger logger;

    public CExtentReport(CLogger logger, String reportDir) {
        this(logger, reportDir, CConfigs.ExtentReport.getExtentReportName() + " " + CConfigs.Core.getRunName(), CConfigs.ExtentReport.getExtentReportFileName() + CConfigs.Core.getRunName());
    }

    public CExtentReport(CLogger logger, String reportDir, String reportName, String reportFileName) {
        this.logger = logger;
        this.extentHtmlReporter = this.buildExtentHtmlReporter(reportDir, reportName, reportFileName);
        this.attachReporter(new ExtentReporter[]{this.extentHtmlReporter});
        this.addConfigurationInformation();
    }

    private static String getTestMethodName(CTestResult exec) {
        CList<String> issueIds = new CList<String>((Iterable<String>)exec.getTestIds());
        if (!issueIds.isEmpty()) {
            return issueIds.mapToSet(id -> CStringUtil.format("<a style=\"color:Red\" href=\"%s\">%s</a>", CConfigs.TestManagement.getUrlToTest(id), id)).join("<br />");
        }
        return exec.getMethodName();
    }

    private static String getTestMethodDescription(CTestResult exec) {
        return (String)CStringUtil.defaultIfBlank((CharSequence)exec.getDescription(), (CharSequence)exec.getTestFullName());
    }

    public synchronized ExtentTest createTest(String projectName, String versionName, ITestResult result) {
        CTestResult cTestResult = new CTestResult(projectName, versionName, result);
        return super.createTest(CExtentReport.getTestMethodName(cTestResult), CExtentReport.getTestMethodDescription(cTestResult));
    }

    private void addConfigurationInformation() {
        CConfigs.getConfigs().forEach(c -> this.setSystemInfo(c.getName(), c.isSensitive() ? "******" : c.getValue()));
    }

    private ExtentHtmlReporter buildExtentHtmlReporter(String reportDir, String reportName, String reportFileName) {
        File file = new File(reportDir, reportFileName.replaceAll(".html", "") + ".html");
        this.logger.debug("Create extent report %s ", file.getPath());
        if (file.exists()) {
            file.delete();
        }
        ExtentHtmlReporter htmlReporter = new ExtentHtmlReporter(file.getPath());
        htmlReporter.config().setTheme(Theme.STANDARD);
        htmlReporter.config().setDocumentTitle(reportName);
        htmlReporter.config().setEncoding("utf-8");
        htmlReporter.config().setReportName(reportName);
        return htmlReporter;
    }
}

