/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.security;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.catools.common.io.CFile;
import org.catools.common.io.CResource;
import org.catools.common.security.CCertificateException;

public class CCertificate {
    private CResource resource;
    private CFile file;

    public CCertificate(String certResourceName, Class classLoader) {
        this.resource = new CResource(certResourceName, classLoader);
    }

    public CCertificate(String fileName) {
        this.file = new CFile(fileName);
    }

    public Certificate getCertificate() {
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            return fact.generateCertificate(this.getInputStream());
        }
        catch (Throwable t) {
            throw new CCertificateException(t);
        }
    }

    public X509Certificate getX509Certificate() {
        return (X509Certificate)this.getCertificate();
    }

    public SSLContext toSSLContext(String alias) {
        Certificate caCert = this.getCertificate();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyStore.setCertificateEntry(alias, caCert);
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (Throwable t) {
            throw new CCertificateException(t);
        }
    }

    private InputStream getInputStream() {
        if (this.resource != null) {
            return this.resource.getInputStream();
        }
        return this.file.getInputStream();
    }
}

