/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.security;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigs;
import org.catools.common.text.CStringUtil;

public class CSecurityManager {
    private static final CList<String> maskList = new CList();
    private static final CSet<String> ignoreList = new CSet();
    private static final String DEFAULT_MASK = "*".repeat(6);

    public static void clear() {
        CSecurityManager.doAction((maskList, ignoreList) -> {
            maskList.clear();
            ignoreList.clear();
            return true;
        });
    }

    public static void addMask(String ... masks) {
        CSecurityManager.doAction((maskList, ignoreList) -> {
            for (String mask : masks) {
                if (!CStringUtil.isNotBlank((CharSequence)mask)) continue;
                if (!ignoreList.contains(mask) && !maskList.contains(mask)) {
                    maskList.add(mask);
                }
                Collections.sort(maskList, (o1, o2) -> o2.length() - o1.length());
            }
            return true;
        });
    }

    public static void ignore(String ... inputs) {
        CSecurityManager.doAction((maskList, ignoreList) -> {
            for (String input : inputs) {
                if (!CStringUtil.isNotBlank((CharSequence)input)) continue;
                if (!ignoreList.contains(input)) {
                    ignoreList.add(input);
                }
                maskList.removeIf(s -> ignoreList.contains(s));
            }
            return true;
        });
    }

    public static String mask(Object input) {
        AtomicReference<String> message = new AtomicReference<String>(input == null ? "" : input.toString());
        if (CConfigs.Security.shouldMaskSensitiveInfo()) {
            return CSecurityManager.doAction((maskList, ignoreList) -> {
                for (String securityMask : maskList) {
                    while (((String)message.get()).contains(securityMask)) {
                        message.set(((String)message.get()).replace(securityMask, DEFAULT_MASK));
                    }
                }
                return (String)message.get();
            });
        }
        return message.get();
    }

    private static synchronized <T> T doAction(BiFunction<CList<String>, CSet<String>, T> func) {
        return func.apply(maskList, ignoreList);
    }
}

