/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CFile;
import org.catools.common.io.CResource;
import org.catools.common.testng.utils.CTestClassUtil;
import org.catools.common.testng.utils.CXmlSuiteUtils;
import org.catools.common.tests.CTest;
import org.testng.TestNG;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;

public class CTestNGProcessor {
    public static CFile buildTestSuite(CHashMap<String, CSet<String>> testClassesMap, String suiteName, String filename, Consumer<XmlSuite> xmlSuiteAdjuster) {
        CFile file = new CFile(filename);
        file.getParentFile().mkdirs();
        file.write(CXmlSuiteUtils.buildTestSuiteForClasses(testClassesMap, suiteName, xmlSuiteAdjuster).toXml());
        return file;
    }

    public static CFile buildTestSuiteForClasses(CSet<String> testClasses, String filename, Consumer<XmlSuite> xmlSuiteAdjuster) {
        CHashMap<String, CSet<String>> map = new CHashMap<String, CSet<String>>();
        map.put("Auto Generated Test", testClasses);
        return CTestNGProcessor.buildTestSuite(map, "Auto Generated Suite", filename, xmlSuiteAdjuster);
    }

    public static CFile buildTestSuiteForTestIds(CTest testInstance, CSet<String> issueIds, String filename, Consumer<XmlSuite> xmlSuiteAdjuster) {
        CHashMap<String, CSet<String>> map = new CHashMap<String, CSet<String>>();
        map.put("Auto Generated Test", CTestClassUtil.getClassNameMap(testInstance).getAllValues(k -> issueIds.contains(k)).toSet());
        return CTestNGProcessor.buildTestSuite(map, "Auto Generated Suite", filename, xmlSuiteAdjuster);
    }

    public static void processLocalXmlSuite(CTest testInstance, String suiteName) {
        testInstance.verify.Bool.isTrue((Boolean)suiteName.toLowerCase().trim().endsWith(".xml"), "TestNG suite file name should end with xml.", new Object[0]);
        CFile localXmlFile = new CFile(suiteName);
        testInstance.verify.Bool.isTrue((Boolean)localXmlFile.exists(), "Xml file exists. file: " + localXmlFile.getCanonicalPath(), new Object[0]);
        testInstance.logger.info("Running local xml file:" + localXmlFile.getCanonicalPath(), new Object[0]);
        CTestNGProcessor.processFile(testInstance, localXmlFile);
    }

    public static void processResourceXmlSuite(CTest testInstance, String suiteName) {
        testInstance.verify.Bool.isTrue((Boolean)suiteName.toLowerCase().trim().endsWith(".xml"), "TestNG suite file name should end with xml.", new Object[0]);
        String resourceContent = new CResource(suiteName, CConfigs.TestNG.getBaseClassLoader()).getString();
        testInstance.verify.String.isNotBlank(resourceContent, "Xml resource file exists and it is not empty. Resource Name: " + suiteName, new Object[0]);
        CFile localXmlFile = CFile.fromTmp(suiteName);
        localXmlFile.write(resourceContent);
        testInstance.verify.Bool.isTrue((Boolean)localXmlFile.exists(), "Xml file copied to resource folder. file: " + localXmlFile, new Object[0]);
        CTestNGProcessor.processFile(testInstance, localXmlFile);
    }

    public static void processTestByTestIds(CTest testInstance, CSet<String> issueIds, String filename, Consumer<XmlSuite> xmlSuiteAdjuster) {
        CTestNGProcessor.processTestClasses(testInstance, CTestClassUtil.getClassNameMap(testInstance).getAllValues(k -> issueIds.contains(k)).toSet(), filename, xmlSuiteAdjuster);
    }

    public static void processTestClasses(CTest testInstance, CSet<String> testClasses, String filename, Consumer<XmlSuite> xmlSuiteAdjuster) {
        CTestNGProcessor.processFile(testInstance, CTestNGProcessor.buildTestSuiteForClasses(testClasses, filename, xmlSuiteAdjuster));
    }

    public static boolean processXmlSuites(CTest testInstance, Collection<XmlSuite> xmlSuites) {
        try {
            new CList<XmlSuite>((Iterable<XmlSuite>)xmlSuites).forEach(x -> testInstance.logger.trace("Processing Xml Suites \n" + x.toXml(), new Object[0]));
            TestNG testNG = new TestNG();
            testNG.setXmlSuites((List)xmlSuites);
            testNG.run();
            return true;
        }
        catch (Throwable t) {
            testInstance.logger.error(t);
            throw t;
        }
    }

    private static boolean processFile(CTest testInstance, CFile xmlFile) {
        testInstance.logger.info("Processing " + xmlFile, new Object[0]);
        try {
            return CTestNGProcessor.processXmlSuites(testInstance, new Parser(xmlFile.getCanonicalPath()).parse());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

