/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CFile;
import org.catools.common.security.CSecurityManager;
import org.catools.common.testng.utils.CTestReportUtil;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.Reporter;
import org.testng.internal.Utils;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.XMLSuiteResultWriter;

public class CTestNGResultGenerator {
    private static final String FILE_NAME = "bt-testng-results";
    private static final XMLReporterConfig config = new XMLReporterConfig();
    private static XMLStringBuffer rootBuffer;

    public static void generateReport(CList<ISuite> suites, String outputDirectory) {
        config.setOutputDirectory(outputDirectory);
        CTestReportUtil.removeDuplicateResults(suites);
        int passed = 0;
        int failed = 0;
        int skipped = 0;
        for (ISuite s : suites) {
            for (ISuiteResult sr : s.getResults().values()) {
                ITestContext testContext = sr.getTestContext();
                passed += testContext.getPassedTests().size();
                failed += testContext.getFailedTests().size();
                skipped += testContext.getSkippedTests().size();
            }
        }
        rootBuffer = new XMLStringBuffer();
        Properties p = new Properties();
        p.put("passed", (Object)passed);
        p.put("failed", (Object)failed);
        p.put("skipped", (Object)skipped);
        p.put("total", (Object)(passed + failed + skipped));
        rootBuffer.push("testng-results", p);
        CTestNGResultGenerator.writeReporterOutput(rootBuffer);
        for (int i = 0; i < suites.size(); ++i) {
            CTestNGResultGenerator.writeSuite((ISuite)suites.get(i));
        }
        rootBuffer.pop();
        new File(config.getOutputDirectory()).mkdirs();
        Utils.writeUtf8File((String)config.getOutputDirectory(), (String)(FILE_NAME + (Serializable)(CConfigs.TestNG.isLastSuiteRun() ? "" : Integer.valueOf(CConfigs.TestNG.getSuiteRunCounter())) + ".xml"), (XMLStringBuffer)rootBuffer, null);
    }

    private static void writeReporterOutput(XMLStringBuffer xmlBuffer) {
        xmlBuffer.push("reporter-output");
        List output = Reporter.getOutput();
        for (String line : output) {
            if (line == null) continue;
            xmlBuffer.push("line");
            xmlBuffer.addCDATA(CSecurityManager.mask(line));
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private static void writeSuite(ISuite suite) {
        switch (config.getFileFragmentationLevel()) {
            case 1: {
                CTestNGResultGenerator.writeSuiteToBuffer(rootBuffer, suite);
                break;
            }
            case 2: 
            case 3: {
                File suiteFile = CTestNGResultGenerator.referenceSuite(rootBuffer, suite);
                CTestNGResultGenerator.writeSuiteToFile(suiteFile, suite);
            }
        }
    }

    private static void writeSuiteToFile(File suiteFile, ISuite suite) {
        XMLStringBuffer xmlBuffer = new XMLStringBuffer();
        CTestNGResultGenerator.writeSuiteToBuffer(xmlBuffer, suite);
        CFile parentDir = new CFile(suiteFile.getParentFile());
        if (parentDir.exists() || suiteFile.getParentFile().mkdirs()) {
            Utils.writeFile((String)parentDir.getCanonicalPath(), (String)FILE_NAME, (String)xmlBuffer.toXML());
        }
    }

    private static File referenceSuite(XMLStringBuffer xmlBuffer, ISuite suite) {
        String relativePath = suite.getName() + File.separatorChar + FILE_NAME;
        File suiteFile = new File(config.getOutputDirectory(), relativePath);
        Properties attrs = new Properties();
        attrs.setProperty("url", relativePath);
        xmlBuffer.addEmptyElement("suite", attrs);
        return suiteFile;
    }

    private static void writeSuiteToBuffer(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("suite", CTestNGResultGenerator.getSuiteAttributes(suite));
        CTestNGResultGenerator.writeSuiteGroups(xmlBuffer, suite);
        Map results = suite.getResults();
        XMLSuiteResultWriter suiteResultWriter = new XMLSuiteResultWriter(config);
        for (Map.Entry result : results.entrySet()) {
            suiteResultWriter.writeSuiteResult(xmlBuffer, (ISuiteResult)result.getValue());
        }
        xmlBuffer.pop();
    }

    private static void writeSuiteGroups(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("groups");
        Map methodsByGroups = suite.getMethodsByGroups();
        for (Map.Entry entry : methodsByGroups.entrySet()) {
            Properties groupAttrs = new Properties();
            groupAttrs.setProperty("name", (String)entry.getKey());
            xmlBuffer.push("group", groupAttrs);
            Set<ITestNGMethod> groupMethods = CTestNGResultGenerator.getUniqueMethodSet((Collection)entry.getValue());
            for (ITestNGMethod groupMethod : groupMethods) {
                Properties methodAttrs = new Properties();
                methodAttrs.setProperty("name", groupMethod.getMethodName());
                methodAttrs.setProperty("signature", groupMethod.toString());
                methodAttrs.setProperty("class", groupMethod.getRealClass().getName());
                xmlBuffer.addEmptyElement("method", methodAttrs);
            }
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private static Properties getSuiteAttributes(ISuite suite) {
        Properties props = new Properties();
        props.setProperty("name", suite.getName());
        Map results = suite.getResults();
        Date minStartDate = new Date();
        Date maxEndDate = null;
        for (Map.Entry result : results.entrySet()) {
            ITestContext testContext = ((ISuiteResult)result.getValue()).getTestContext();
            Date startDate = testContext.getStartDate();
            Date endDate = testContext.getEndDate();
            if (minStartDate.after(startDate)) {
                minStartDate = startDate;
            }
            if (maxEndDate != null && !maxEndDate.before(endDate)) continue;
            maxEndDate = endDate != null ? endDate : startDate;
        }
        if (maxEndDate == null) {
            maxEndDate = minStartDate;
        }
        CTestNGResultGenerator.addDurationAttributes(config, props, minStartDate, maxEndDate);
        return props;
    }

    private static void addDurationAttributes(XMLReporterConfig config, Properties attributes, Date minStartDate, Date maxEndDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        format.setTimeZone(utc);
        String startTime = format.format(minStartDate);
        String endTime = format.format(maxEndDate);
        long duration = maxEndDate.getTime() - minStartDate.getTime();
        attributes.setProperty("started-at", startTime);
        attributes.setProperty("finished-at", endTime);
        attributes.setProperty("duration-ms", Long.toString(duration));
    }

    private static Set<ITestNGMethod> getUniqueMethodSet(Collection<ITestNGMethod> methods) {
        LinkedHashSet<ITestNGMethod> result = new LinkedHashSet<ITestNGMethod>();
        for (ITestNGMethod method : methods) {
            result.add(method);
        }
        return result;
    }
}

