/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.listeners;

import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CFile;
import org.catools.common.json.CJsonUtil;
import org.catools.common.testng.listeners.CITestNGListener;
import org.catools.common.testng.model.CTestResult;
import org.catools.common.testng.model.CTestResults;
import org.catools.common.testng.utils.CRetryAnalyzer;
import org.catools.common.testng.utils.CTestClassUtil;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class CExecutionResultListener
implements CITestNGListener {
    private static final CTestResults executionResults = new CTestResults();
    private String projectName = CConfigs.TestManagement.getProjectName();
    private String versionName = CConfigs.TestManagement.getVersionName();

    public static boolean isPassed(ITestNGMethod method) {
        return executionResults.isPassed(method);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public void onStart(ITestContext context) {
        CList<ITestNGMethod> allMethods = new CList<ITestNGMethod>(context.getSuite().getAllMethods());
        allMethods.removeIf(m -> {
            CTestResult testResult = executionResults.getTestResultOrNull((ITestNGMethod)m);
            return testResult != null && testResult.getStatus().isPassed();
        });
        allMethods.getAll(m -> m != null && m.getRetryAnalyzer() != null).forEach(m -> ((CRetryAnalyzer)m.getRetryAnalyzer()).resetCount());
    }

    @Override
    public synchronized void onTestSuccess(ITestResult result) {
        this.addResult(result);
    }

    @Override
    public synchronized void onTestFailure(ITestResult result) {
        if (CTestClassUtil.noRetryLeft(result, true)) {
            this.addResult(result);
        }
    }

    @Override
    public synchronized void onTestSkipped(ITestResult result) {
        if (CTestClassUtil.noRetryLeft(result, true)) {
            this.addResult(result);
        }
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        if (CTestClassUtil.noRetryLeft(result, true)) {
            this.addResult(result);
        }
    }

    @Override
    public void onExecutionFinish() {
        CJsonUtil.write(CFile.fromOutput("./CTestResultCollection.json"), executionResults);
    }

    private boolean addResult(ITestResult result) {
        return executionResults.add(new CTestResult(this.projectName, this.versionName, result));
    }
}

