/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.listeners;

import org.catools.common.collections.CHashMap;
import org.catools.common.config.CConfigs;
import org.catools.common.testng.listeners.CITestNGListener;
import org.catools.common.testng.model.CExecutionStatus;
import org.catools.common.text.CStringUtil;
import org.testng.ISuite;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class CExecutionStatisticListener
implements CITestNGListener {
    public static final CHashMap<String, CExecutionStatus> signatures = new CHashMap();

    public static String getStatistics() {
        if (signatures.isEmpty()) {
            return "";
        }
        int total = signatures.size();
        int passed = signatures.getAllKeys(v -> v.isPassed()).size();
        int failed = signatures.getAllKeys(v -> v.isFailed()).size();
        int skipped = signatures.getAllKeys(v -> v.isSkipped()).size();
        int left = total - passed - failed - skipped;
        return CStringUtil.format("R%s/%s T%s L%s P%s F%s S%s", CConfigs.TestNG.getSuiteRunCounter(), CConfigs.TestNG.getSuiteRetryCount() + 1, total, left, passed, failed, skipped);
    }

    public static void startSuite(ISuite suite) {
        suite.getAllMethods().forEach(m -> CExecutionStatisticListener.updateTestResult(m, CExecutionStatus.CREATED));
    }

    public static void updateTestResult(ITestNGMethod method, CExecutionStatus status) {
        signatures.put(method.getTestClass().getName() + method.getMethodName(), status);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public void onStart(ISuite suite) {
        signatures.clear();
        CExecutionStatisticListener.startSuite(suite);
    }

    @Override
    public void onTestStart(ITestResult result) {
        CExecutionStatisticListener.updateTestResult(result.getMethod(), CExecutionStatus.WIP);
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        CExecutionStatisticListener.updateTestResult(result.getMethod(), CExecutionStatus.SUCCESS);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        CExecutionStatisticListener.updateTestResult(result.getMethod(), CExecutionStatus.FAILURE);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        CExecutionStatisticListener.updateTestResult(result.getMethod(), CExecutionStatus.SKIP);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        CExecutionStatisticListener.updateTestResult(result.getMethod(), CExecutionStatus.SUCCESS);
    }
}

