/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.listeners;

import com.aventstack.extentreports.ExtentTest;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigs;
import org.catools.common.logger.CLogger;
import org.catools.common.reports.CExtentReport;
import org.catools.common.testng.listeners.CITestNGListener;
import org.catools.common.testng.model.CTestResult;
import org.catools.common.testng.utils.CTestClassUtil;
import org.testng.ISuite;
import org.testng.ITestResult;

public class CExtentReportListener
implements CITestNGListener {
    private static final CLogger logger = new CLogger("CExtentReportListener");
    private static final ThreadLocal<ExtentTest> overallTest = new ThreadLocal();
    private static final ThreadLocal<ExtentTest> suiteTest = new ThreadLocal();
    private static final CSet<String> startedTests = new CSet();
    private static CExtentReport overAllExtentReport;
    private static CExtentReport suiteExtentReport;
    private String projectName = CConfigs.TestManagement.getProjectName();
    private String versionName = CConfigs.TestManagement.getVersionName();

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public void onExecutionStart() {
        if (CConfigs.ExtentReport.isEnable()) {
            overAllExtentReport = new CExtentReport(logger, CConfigs.Path.getOutputRoot().getCanonicalPath(), "Overall Extent Report", "OverallExtentReport");
        }
    }

    @Override
    public void onStart(ISuite suite) {
        if (CConfigs.ExtentReport.isEnable()) {
            suiteExtentReport = new CExtentReport(logger, CConfigs.Path.getOutputPath());
            startedTests.clear();
        }
    }

    @Override
    public synchronized void onTestStart(ITestResult result) {
        String key = String.format("%s->%s->%s", this.projectName, this.versionName, new CTestResult(this.projectName, this.versionName, result).getTestFullName());
        if (suiteExtentReport != null && !startedTests.contains(key)) {
            startedTests.add(key);
            suiteTest.set(suiteExtentReport.createTest(this.projectName, this.versionName, result));
            overallTest.set(overAllExtentReport.createTest(this.projectName, this.versionName, result));
        }
    }

    @Override
    public synchronized void onTestSuccess(ITestResult result) {
        if (suiteExtentReport != null && suiteTest.get() != null) {
            suiteTest.get().pass("Test passed");
            overallTest.get().pass("Test passed");
        }
    }

    @Override
    public synchronized void onTestFailure(ITestResult result) {
        if (suiteExtentReport != null && suiteTest.get() != null) {
            if (CTestClassUtil.noRetryLeft(result, false)) {
                suiteTest.get().fail(result.getThrowable());
            }
            if (CTestClassUtil.noRetryLeft(result, true)) {
                overallTest.get().fail(result.getThrowable());
            }
        }
    }

    @Override
    public synchronized void onTestSkipped(ITestResult result) {
        if (suiteExtentReport != null && suiteTest.get() != null) {
            if (CTestClassUtil.noRetryLeft(result, false)) {
                suiteTest.get().skip(result.getThrowable());
            }
            if (CTestClassUtil.noRetryLeft(result, true)) {
                overallTest.get().skip(result.getThrowable());
            }
        }
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        if (suiteExtentReport != null && suiteTest.get() != null) {
            if (CTestClassUtil.noRetryLeft(result, false)) {
                suiteTest.get().pass("Passed with failed percentage.");
            }
            if (CTestClassUtil.noRetryLeft(result, true)) {
                overallTest.get().pass("Passed with failed percentage.");
            }
        }
    }

    @Override
    public void onFinish(ISuite suite) {
        if (suiteExtentReport != null) {
            suiteExtentReport.flush();
        }
    }

    @Override
    public void onExecutionFinish() {
        if (overAllExtentReport != null) {
            overAllExtentReport.flush();
        }
    }
}

