/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.listeners;

import java.lang.annotation.Annotation;
import java.util.List;
import org.catools.common.annotations.CRegression;
import org.catools.common.annotations.CSeverity;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;
import org.catools.common.testng.listeners.CExecutionResultListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public class CIMethodInterceptor
implements IMethodInterceptor {
    public List<IMethodInstance> intercept(List<IMethodInstance> list, ITestContext iTestContext) {
        if (!list.isEmpty()) {
            list.removeIf(method -> CIMethodInterceptor.shouldSkip(method.getMethod()));
        }
        return list;
    }

    private static boolean shouldSkip(ITestNGMethod method) {
        CList<Annotation> annotations = CIMethodInterceptor.getAnnotations(method);
        if (!method.isTest()) {
            return false;
        }
        if (CExecutionResultListener.isPassed(method)) {
            return true;
        }
        int severityLevel = CConfigs.TestNG.getSeverityLevel();
        int regressionDepth = CConfigs.TestNG.getRegressionDepth();
        if (severityLevel == -1 && regressionDepth == -1) {
            return false;
        }
        boolean hasSeverity = annotations.has(a -> a instanceof CSeverity);
        boolean hasRegression = annotations.has(a -> a instanceof CRegression);
        if (severityLevel > -1 && regressionDepth > -1) {
            if (hasSeverity && hasRegression) {
                return CIMethodInterceptor.skipBySeverityLevel(annotations) || CIMethodInterceptor.skipByRegressionLevel(annotations);
            }
            return true;
        }
        if (severityLevel > -1) {
            return !hasSeverity || CIMethodInterceptor.skipBySeverityLevel(annotations);
        }
        if (regressionDepth > -1) {
            return !hasRegression || CIMethodInterceptor.skipByRegressionLevel(annotations);
        }
        return false;
    }

    private static boolean skipBySeverityLevel(CList<Annotation> annotations) {
        return annotations.has(a -> a instanceof CSeverity && ((CSeverity)a).level() > CConfigs.TestNG.getSeverityLevel());
    }

    private static boolean skipByRegressionLevel(CList<Annotation> annotations) {
        return annotations.has(a -> a instanceof CRegression && ((CRegression)a).depth() > CConfigs.TestNG.getRegressionDepth());
    }

    private static CList<Annotation> getAnnotations(ITestNGMethod method) {
        if (!CIMethodInterceptor.hasAnnotation(method)) {
            return new CList<Annotation>();
        }
        return new CList<Annotation>(method.getConstructorOrMethod().getMethod().getAnnotations());
    }

    private static boolean hasAnnotation(ITestNGMethod method) {
        return method != null && method.getConstructorOrMethod() != null && method.getConstructorOrMethod().getMethod() != null && method.getConstructorOrMethod().getMethod().getAnnotations() != null;
    }
}

