/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.listeners;

import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;
import org.catools.common.functions.CMemoize;
import org.catools.common.testng.CTestNGResultGenerator;
import org.catools.common.testng.listeners.CITestNGListener;
import org.catools.common.testng.utils.CTestClassUtil;
import org.catools.common.testng.utils.CXmlSuiteUtils;
import org.catools.common.tests.CSkipAwaitingTestException;
import org.testng.IAlterSuiteListener;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IInvokedMethodListener2;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.xml.XmlSuite;

public class CTestNGListener
implements CITestNGListener,
IMethodInterceptor,
IAlterSuiteListener,
IReporter {
    private static final CMemoize<Integer> suiteConter = new CMemoize<Object>(() -> CConfigs.TestNG.incrementSuiteRun());
    private static final CList<ITestNGListener> globalListeners = new CList();
    private static final CList<ISuite> suites = new CList();
    private final CList<ITestNGListener> instanceListeners = new CList();

    public CTestNGListener() {
        CConfigs.TestNG.getListeners().forEach(l -> this.addListeners((ITestNGListener)l));
    }

    public static void addGlobalListeners(ITestNGListener ... listeners) {
        globalListeners.addAll(new CList<ITestNGListener>(listeners));
    }

    public CTestNGListener addListeners(ITestNGListener ... listeners) {
        this.instanceListeners.addAll(new CList<ITestNGListener>(listeners));
        return this;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public void onExecutionStart() {
        this.doIf(l -> l instanceof IExecutionListener, l -> ((IExecutionListener)l).onExecutionStart());
    }

    @Override
    public void onStart(ISuite suite) {
        this.doIf(l -> l instanceof ISuiteListener, l -> ((ISuiteListener)l).onStart(suite));
        suiteConter.reset();
    }

    @Override
    public void beforeConfiguration(ITestResult result) {
        this.doIf(l -> l instanceof IConfigurationListener2, l -> ((IConfigurationListener2)l).beforeConfiguration(result));
    }

    @Override
    public void onConfigurationSuccess(ITestResult result) {
        this.doIf(l -> l instanceof IConfigurationListener, l -> ((IConfigurationListener)l).onConfigurationSuccess(result));
    }

    @Override
    public void onConfigurationFailure(ITestResult result) {
        this.doIf(l -> l instanceof IConfigurationListener, l -> ((IConfigurationListener)l).onConfigurationFailure(result));
    }

    @Override
    public void onConfigurationSkip(ITestResult result) {
        this.doIf(l -> l instanceof IConfigurationListener, l -> ((IConfigurationListener)l).onConfigurationSkip(result));
    }

    @Override
    public void onStart(ITestContext context) {
        this.doIf(l -> l instanceof ITestListener, l -> ((ITestListener)l).onStart(context));
    }

    @Override
    public void onBeforeClass(ITestClass testClass) {
        if (CTestClassUtil.shouldBeSkipped(testClass.getInstances(false)[0].getClass())) {
            throw new CSkipAwaitingTestException("Test Class Contains One or More CAwaiting/Ignored issue cases!");
        }
        this.doIf(l -> l instanceof IClassListener, l -> ((IClassListener)l).onBeforeClass(testClass));
    }

    @Override
    public void onTestStart(ITestResult result) {
        this.doIf(l -> l instanceof ITestListener, l -> ((ITestListener)l).onTestStart(result));
    }

    @Override
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        this.doIf(l -> l instanceof IInvokedMethodListener, l -> ((IInvokedMethodListener)l).beforeInvocation(method, testResult));
    }

    @Override
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
        if (method.isTestMethod() && CConfigs.Core.isDataSetupModeOn()) {
            throw new SkipException("Data Setup Mode, Skipping Test Method");
        }
        this.doIf(l -> l instanceof IInvokedMethodListener2, l -> ((IInvokedMethodListener2)l).beforeInvocation(method, testResult, context));
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        this.doIf(l -> l instanceof IInvokedMethodListener, l -> ((IInvokedMethodListener)l).afterInvocation(method, testResult));
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
        this.doIf(l -> l instanceof IInvokedMethodListener2, l -> ((IInvokedMethodListener2)l).afterInvocation(method, testResult, context));
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        this.doIf(l -> l instanceof ITestListener, l -> ((ITestListener)l).onTestSuccess(result));
    }

    @Override
    public void onTestFailure(ITestResult result) {
        this.doIf(l -> l instanceof ITestListener, l -> ((ITestListener)l).onTestFailure(result));
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        this.doIf(l -> l instanceof ITestListener, l -> ((ITestListener)l).onTestSkipped(result));
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.doIf(l -> l instanceof ITestListener, l -> ((ITestListener)l).onTestFailedButWithinSuccessPercentage(result));
    }

    @Override
    public void onAfterClass(ITestClass testClass) {
        this.doIf(l -> l instanceof IClassListener, l -> ((IClassListener)l).onAfterClass(testClass));
    }

    @Override
    public void onFinish(ITestContext context) {
        this.doIf(l -> l instanceof ITestListener, l -> ((ITestListener)l).onFinish(context));
    }

    @Override
    public void onFinish(ISuite suite) {
        this.doIf(l -> l instanceof ISuiteListener, l -> ((ISuiteListener)l).onFinish(suite));
        suites.add(suite);
        suiteConter.get();
    }

    @Override
    public void onExecutionFinish() {
        this.doIf(l -> l instanceof IExecutionListener, l -> ((IExecutionListener)l).onExecutionFinish());
        CTestNGResultGenerator.generateReport(suites, CConfigs.Path.getOutputPath());
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> list, ITestContext iTestContext) {
        CList<ITestNGListener> methodInterceptor = this.instanceListeners.getAll(l -> l instanceof IMethodInterceptor);
        if (!methodInterceptor.isEmpty()) {
            return ((IMethodInterceptor)methodInterceptor.getFirst()).intercept(list, iTestContext);
        }
        return list;
    }

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        this.doIf(l -> l instanceof IReporter, l -> ((IReporter)l).generateReport(xmlSuites, suites, outputDirectory));
    }

    public void alter(List<XmlSuite> list) {
        CList<XmlSuite> retryList = new CList<XmlSuite>();
        for (int i = 0; i < CConfigs.TestNG.getSuiteRetryCount(); ++i) {
            for (XmlSuite xmlSuite : list) {
                XmlSuite suite = CXmlSuiteUtils.copy(xmlSuite, " Retry " + (i + 1));
                retryList.add(suite);
            }
        }
        list.addAll(retryList);
    }

    private <T extends ITestNGListener> void doIf(Predicate<ITestNGListener> predicate, Consumer<T> action) {
        CList<ITestNGListener> list = new CList<ITestNGListener>((Iterable<ITestNGListener>)globalListeners.getAll(predicate));
        list.addAll(this.instanceListeners.getAll(predicate));
        if (list.isEmpty()) {
            return;
        }
        CList<ITestNGListener> cListeners = list.getAll(l -> l instanceof CITestNGListener);
        cListeners.sort(Comparator.comparingInt(f -> ((CITestNGListener)f).priority()));
        cListeners.forEach(l -> action.accept(l));
        list.getAll(l -> !(l instanceof CITestNGListener)).forEach(l -> action.accept(l));
    }
}

