/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.catools.common.annotations.CAwaiting;
import org.catools.common.annotations.CDefects;
import org.catools.common.annotations.CDeferred;
import org.catools.common.annotations.CIgnored;
import org.catools.common.annotations.COpenDefects;
import org.catools.common.annotations.CRegression;
import org.catools.common.annotations.CSeverity;
import org.catools.common.annotations.CTestIds;
import org.catools.common.collections.CList;
import org.catools.common.date.CDate;
import org.catools.common.exception.CExceptionInfo;
import org.catools.common.testng.model.CExecutionStatus;
import org.catools.common.text.CStringUtil;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class CTestResult
implements Comparable<CTestResult> {
    private int testExecutionId;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssZ")
    private CDate startTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssZ")
    private CDate endTime;
    private String packageName;
    private String className;
    private String methodName;
    private CExecutionStatus status;
    private Object[] annotations;
    private Object[] parameters;
    private CExceptionInfo exceptionInfo;
    private long duration;
    private String name;
    private String description;
    private String host;
    private CList<String> methodGroups = new CList();
    private CList<String> testIds = new CList();
    private CList<String> defectIds = new CList();
    private CList<String> openDefectIds = new CList();
    private CList<String> deferredId = new CList();
    private String awaiting = "";
    private boolean configurationMethod = true;
    private String project;
    private String version;
    private Integer severityLevel = null;
    private Integer regressionDepth = null;

    public CTestResult() {
    }

    public CTestResult(String project, String version, ITestResult testResult) {
        this.project = project;
        this.version = version;
        this.className = testResult.getMethod().getTestClass().getName();
        this.packageName = testResult.getMethod().getRealClass().getPackage().getName();
        if (testResult.getMethod().getGroups() != null) {
            this.methodGroups.addAll(Arrays.asList(testResult.getMethod().getGroups()));
        }
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        this.methodName = method.getName();
        this.annotations = method.getAnnotations();
        this.parameters = testResult.getParameters();
        this.exceptionInfo = new CExceptionInfo(testResult.getThrowable());
        this.duration = testResult.getEndMillis() - testResult.getStartMillis();
        this.name = testResult.getName();
        this.host = testResult.getHost();
        this.description = testResult.getMethod().getDescription();
        this.startTime = new CDate(testResult.getStartMillis());
        this.endTime = new CDate(testResult.getEndMillis());
        boolean ignored = false;
        for (Object annotation : this.annotations) {
            if (annotation instanceof CTestIds) {
                this.testIds.addAll(Arrays.asList(((CTestIds)annotation).ids()));
                continue;
            }
            if (annotation instanceof CDeferred) {
                this.deferredId.addAll(Arrays.asList(((CDeferred)annotation).ids()));
                continue;
            }
            if (annotation instanceof CDefects) {
                this.defectIds.addAll(Arrays.asList(((CDefects)annotation).ids()));
                continue;
            }
            if (annotation instanceof COpenDefects) {
                this.openDefectIds.addAll(Arrays.asList(((COpenDefects)annotation).ids()));
                continue;
            }
            if (annotation instanceof CAwaiting) {
                this.awaiting = ((CAwaiting)annotation).cause();
                continue;
            }
            if (annotation instanceof CIgnored) {
                ignored = true;
                continue;
            }
            if (annotation instanceof CRegression) {
                this.regressionDepth = ((CRegression)annotation).depth();
                continue;
            }
            if (annotation instanceof CSeverity) {
                this.severityLevel = ((CSeverity)annotation).level();
                continue;
            }
            if (!(annotation instanceof Test)) continue;
            this.configurationMethod = false;
        }
        this.status = testResult.getStatus() == 1 ? CExecutionStatus.SUCCESS : (!this.awaiting.isEmpty() ? CExecutionStatus.AWAITING : (ignored ? CExecutionStatus.IGNORED : (!this.deferredId.isEmpty() ? CExecutionStatus.DEFERRED : (testResult.getStatus() == 2 ? CExecutionStatus.FAILURE : CExecutionStatus.SKIP))));
        this.testExecutionId = this.hashCode();
    }

    public Object[] getAnnotations() {
        return this.annotations;
    }

    public String getAwaiting() {
        return this.awaiting;
    }

    public String getClassName() {
        return this.className;
    }

    public CList<String> getDefectIds() {
        return this.defectIds;
    }

    public CList<String> getDeferredIds() {
        return this.deferredId;
    }

    public String getDescription() {
        return this.description;
    }

    public long getDuration() {
        return this.duration;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public CExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public String getFullName() {
        return this.className + "." + this.name;
    }

    public String getHost() {
        return this.host;
    }

    public CList<String> getTestIds() {
        return this.testIds;
    }

    public CList<String> getMethodGroups() {
        return this.methodGroups;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getName() {
        return this.name;
    }

    public CList<String> getOpenDefectIds() {
        return this.openDefectIds;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String getProject() {
        return this.project;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public CExecutionStatus getStatus() {
        return this.status;
    }

    public int getTestExecutionId() {
        return this.testExecutionId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasException() {
        return this.exceptionInfo != null && CStringUtil.isNotBlank((CharSequence)this.exceptionInfo.getType());
    }

    public boolean isConfigurationMethod() {
        return this.configurationMethod;
    }

    public Integer getSeverityLevel() {
        return this.severityLevel;
    }

    public Integer getRegressionDepth() {
        return this.regressionDepth;
    }

    public String getTestFullName() {
        return this.getPackageName() + "." + this.getClassName() + "::" + this.getMethodName();
    }

    @Override
    public int compareTo(CTestResult o) {
        if (o == null) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTestResult that = (CTestResult)o;
        return this.testExecutionId == that.testExecutionId && this.duration == that.duration && this.configurationMethod == that.configurationMethod && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && this.status == that.status && Arrays.equals(this.annotations, that.annotations) && Arrays.equals(this.parameters, that.parameters) && Objects.equals(this.exceptionInfo, that.exceptionInfo) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.host, that.host) && Objects.equals(this.methodGroups, that.methodGroups) && Objects.equals(this.testIds, that.testIds) && Objects.equals(this.defectIds, that.defectIds) && Objects.equals(this.openDefectIds, that.openDefectIds) && Objects.equals(this.deferredId, that.deferredId) && Objects.equals(this.awaiting, that.awaiting) && Objects.equals(this.project, that.project) && Objects.equals(this.version, that.version) && Objects.equals(this.severityLevel, that.severityLevel) && Objects.equals(this.regressionDepth, that.regressionDepth);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.testExecutionId, this.startTime, this.endTime, this.packageName, this.className, this.methodName, this.status, this.exceptionInfo, this.duration, this.name, this.description, this.host, this.methodGroups, this.testIds, this.defectIds, this.openDefectIds, this.deferredId, this.awaiting, this.configurationMethod, this.project, this.version, this.severityLevel, this.regressionDepth});
        result = 31 * result + Arrays.hashCode(this.annotations);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public String toString() {
        return "CTestResult{testExecutionId=" + this.testExecutionId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", packageName='" + this.packageName + "', className='" + this.className + "', methodName='" + this.methodName + "', status=" + this.status + ", annotations=" + Arrays.toString(this.annotations) + ", parameters=" + Arrays.toString(this.parameters) + ", exceptionInfo=" + this.exceptionInfo + ", duration=" + this.duration + ", name='" + this.name + "', description='" + this.description + "', host='" + this.host + "', methodGroups=" + this.methodGroups + ", testIds=" + this.testIds + ", defectIds=" + this.defectIds + ", openDefectIds=" + this.openDefectIds + ", deferredId=" + this.deferredId + ", awaiting='" + this.awaiting + "', configurationMethod=" + this.configurationMethod + ", project='" + this.project + "', version='" + this.version + "', severityLevel=" + this.severityLevel + ", regressionDepth=" + this.regressionDepth + "}";
    }
}

