/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.stream.Stream;
import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.testng.model.CExecutionStatus;
import org.catools.common.testng.model.CTestResult;
import org.testng.ITestNGMethod;

public class CTestResults
extends CList<CTestResult> {
    public CTestResults() {
    }

    public CTestResults(CTestResult ... c) {
        super(c);
    }

    public CTestResults(Stream<CTestResult> stream) {
        super(stream);
    }

    public CTestResults(Iterable<CTestResult> iterable) {
        super(iterable);
    }

    @JsonIgnore
    public CTestResult getTestResultOrNull(ITestNGMethod testNGMethod) {
        return this.getFirstOrNull(test -> test.getClassName().equals(testNGMethod.getTestClass().getName()) && test.getMethodName().equals(testNGMethod.getMethodName()));
    }

    @JsonIgnore
    public boolean isPassed(ITestNGMethod method) {
        CTestResult testResultByMethod = this.getFirstOrNull(test -> test.getClassName().equals(method.getTestClass().getName()) && test.getMethodName().equals(method.getMethodName()));
        return testResultByMethod != null && testResultByMethod.getStatus().isPassed();
    }

    @JsonIgnore
    public CTestResult getTestResultByIdOrNull(String id) {
        return this.getFirstOrElse(test -> test.getTestIds() != null && test.getTestIds().contains(id), null);
    }

    public CSet<String> getAllIssueIds() {
        CSet<String> ids = new CSet<String>();
        for (CTestResult result : this) {
            ids.addAll(result.getTestIds());
        }
        return ids;
    }

    public CHashMap<CExecutionStatus, CTestResults> getStatusMap() {
        CHashMap<CExecutionStatus, CTestResults> keys = new CHashMap<CExecutionStatus, CTestResults>();
        for (CTestResult result : this) {
            keys.putIfAbsent(result.getStatus(), new CTestResults());
            keys.get((Object)result.getStatus()).add(result);
        }
        return keys;
    }
}

