/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.utils;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.catools.common.annotations.CAwaiting;
import org.catools.common.annotations.CIgnored;
import org.catools.common.annotations.CTestIds;
import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigs;
import org.catools.common.testng.utils.CRetryAnalyzer;
import org.catools.common.tests.CTest;
import org.testng.ITestResult;

public class CTestClassUtil {
    private static final CHashMap<String, String> keyClassMap = new CHashMap();

    public static CSet<String> getClassNameForIssueKeys(CTest testInstance, CSet<String> issueIds) {
        return CTestClassUtil.getClassNameMap(testInstance).getAllValues(k -> issueIds.contains(k)).toSet();
    }

    public static CHashMap<String, String> getClassNameMap(CTest testInstance) {
        if (keyClassMap.isEmpty()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                ClassPath classpath = ClassPath.from((ClassLoader)loader);
                for (String testPackage : CConfigs.TestNG.getTestPackages()) {
                    for (ClassPath.ClassInfo classInfo : classpath.getTopLevelClassesRecursive(testPackage)) {
                        new CList<Method>(classInfo.load().getMethods()).forEach(m -> {
                            for (Annotation annotation : m.getAnnotations()) {
                                if (!(annotation instanceof CTestIds)) continue;
                                Arrays.asList(((CTestIds)annotation).ids()).forEach(s -> {
                                    if (!keyClassMap.containsKey(s)) {
                                        keyClassMap.put((String)s, classInfo.getName());
                                    }
                                });
                            }
                        });
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        testInstance.logger.info(keyClassMap.size() + " tests class found.", new Object[0]);
        return keyClassMap;
    }

    public static String getTestName(Class testClazz) {
        return testClazz.getName().replaceAll("\\W", "_");
    }

    public static boolean noRetryLeft(ITestResult result, boolean considerSuiteRetry) {
        if (considerSuiteRetry && !CConfigs.TestNG.isLastSuiteRun()) {
            return false;
        }
        return result.getMethod() == null || result.getMethod().getRetryAnalyzer() == null || ((CRetryAnalyzer)result.getMethod().getRetryAnalyzer()).isLastRetry();
    }

    public static boolean shouldBeSkipped(Class clazz) {
        if (CConfigs.TestNG.skipClassWithAwaitingTest()) {
            for (Method method : clazz.getMethods()) {
                if (!Arrays.stream(method.getAnnotations()).filter(an -> an instanceof CAwaiting).findFirst().isPresent()) continue;
                return true;
            }
        }
        if (CConfigs.TestNG.skipClassWithIgnoredTest()) {
            for (Method method : clazz.getMethods()) {
                if (!Arrays.stream(method.getAnnotations()).filter(an -> an instanceof CIgnored).findFirst().isPresent()) continue;
                return true;
            }
        }
        return false;
    }
}

