/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.utils;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class CTestReportUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDuplicateResults(CList<ISuite> suites) {
        CList<Pair<ITestContext, CSet<ITestResult>>> totalPassed = new CList<Pair<ITestContext, CSet<ITestResult>>>();
        CList<Pair<ITestContext, CSet<ITestResult>>> totalFailed = new CList<Pair<ITestContext, CSet<ITestResult>>>();
        CList<Pair<ITestContext, CSet<ITestResult>>> totalSkipped = new CList<Pair<ITestContext, CSet<ITestResult>>>();
        CList<Pair<ITestContext, CSet<ITestResult>>> totalPassedConfig = new CList<Pair<ITestContext, CSet<ITestResult>>>();
        CList<Pair<ITestContext, CSet<ITestResult>>> totalFailedConfig = new CList<Pair<ITestContext, CSet<ITestResult>>>();
        CList<Pair<ITestContext, CSet<ITestResult>>> totalSkippedConfig = new CList<Pair<ITestContext, CSet<ITestResult>>>();
        CList<ISuite> cList = suites;
        synchronized (cList) {
            suites.sort(Comparator.comparing(ISuite::getName));
            CTestReportUtil.refreshList(suites, totalPassed, totalFailed, totalSkipped, totalPassedConfig, totalFailedConfig, totalSkippedConfig);
            CTestReportUtil.removeDuplicate(totalPassed, (context, result) -> context.getPassedTests().getAllResults().remove(result));
            CTestReportUtil.removeDuplicate(totalPassed, (context, result) -> context.getFailedButWithinSuccessPercentageTests().getAllResults().remove(result));
            CTestReportUtil.removeDuplicate(totalFailed, (context, result) -> context.getFailedTests().getAllResults().remove(result));
            CTestReportUtil.removeDuplicate(totalFailed, (context, result) -> context.getFailedButWithinSuccessPercentageTests().getAllResults().remove(result));
            CTestReportUtil.removeDuplicate(totalSkipped, (context, result) -> context.getSkippedTests().getAllResults().remove(result));
            CTestReportUtil.removeDuplicate(totalPassedConfig, (context, result) -> context.getPassedConfigurations().getAllResults().remove(result));
            CTestReportUtil.removeDuplicate(totalFailedConfig, (context, result) -> context.getFailedConfigurations().getAllResults().remove(result));
            CTestReportUtil.removeDuplicate(totalSkippedConfig, (context, result) -> context.getSkippedConfigurations().getAllResults().remove(result));
            CTestReportUtil.refreshList(suites, totalPassed, totalFailed, totalSkipped, totalPassedConfig, totalFailedConfig, totalSkippedConfig);
            CTestReportUtil.removeMatches(totalPassed, totalFailed, (context, result) -> context.getFailedTests().getAllResults().remove(result));
            CTestReportUtil.removeMatches(totalPassed, totalSkipped, (context, result) -> context.getSkippedTests().getAllResults().remove(result));
            CTestReportUtil.removeMatches(totalFailed, totalSkipped, (context, result) -> context.getSkippedTests().getAllResults().remove(result));
            CTestReportUtil.removeMatches(totalPassedConfig, totalFailedConfig, (context, result) -> context.getFailedConfigurations().getAllResults().remove(result));
            CTestReportUtil.removeMatches(totalPassedConfig, totalSkippedConfig, (context, result) -> context.getSkippedConfigurations().getAllResults().remove(result));
            CTestReportUtil.removeMatches(totalFailedConfig, totalSkippedConfig, (context, result) -> context.getSkippedConfigurations().getAllResults().remove(result));
        }
    }

    private static void removeMatches(CList<Pair<ITestContext, CSet<ITestResult>>> mainList, CList<Pair<ITestContext, CSet<ITestResult>>> toBeClean, BiConsumer<ITestContext, ITestResult> remove) {
        for (Pair pair : mainList) {
            for (Map.Entry entry : toBeClean) {
                CTestReportUtil.removeDuplicate((CSet)pair.getRight(), entry, remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshList(CList<ISuite> suites, CList<Pair<ITestContext, CSet<ITestResult>>> totalPassed, CList<Pair<ITestContext, CSet<ITestResult>>> totalFailed, CList<Pair<ITestContext, CSet<ITestResult>>> totalSkipped, CList<Pair<ITestContext, CSet<ITestResult>>> totalPassedConfig, CList<Pair<ITestContext, CSet<ITestResult>>> totalFailedConfig, CList<Pair<ITestContext, CSet<ITestResult>>> totalSkippedConfig) {
        totalPassed.clear();
        totalFailed.clear();
        totalSkipped.clear();
        totalPassedConfig.clear();
        totalFailedConfig.clear();
        totalSkippedConfig.clear();
        Iterator iterator = suites.iterator();
        while (iterator.hasNext()) {
            ISuite suite;
            ISuite iSuite = suite = (ISuite)iterator.next();
            synchronized (iSuite) {
                for (ISuiteResult sr : suite.getResults().values()) {
                    ITestContext testContext = sr.getTestContext();
                    Pair passed = Pair.of((Object)testContext, new CSet(testContext.getPassedTests().getAllResults()));
                    ((CSet)passed.getValue()).addAll(testContext.getFailedButWithinSuccessPercentageTests().getAllResults());
                    totalPassed.add((Pair<ITestContext, CSet<ITestResult>>)passed);
                    totalFailed.add((Pair<ITestContext, CSet<ITestResult>>)Pair.of((Object)testContext, new CSet(testContext.getFailedTests().getAllResults())));
                    totalSkipped.add((Pair<ITestContext, CSet<ITestResult>>)Pair.of((Object)testContext, new CSet(testContext.getSkippedTests().getAllResults())));
                    totalPassedConfig.add((Pair<ITestContext, CSet<ITestResult>>)Pair.of((Object)testContext, new CSet(testContext.getPassedConfigurations().getAllResults())));
                    totalFailedConfig.add((Pair<ITestContext, CSet<ITestResult>>)Pair.of((Object)testContext, new CSet(testContext.getFailedConfigurations().getAllResults())));
                    totalSkippedConfig.add((Pair<ITestContext, CSet<ITestResult>>)Pair.of((Object)testContext, new CSet(testContext.getSkippedConfigurations().getAllResults())));
                }
            }
        }
    }

    private static void removeDuplicate(CList<Pair<ITestContext, CSet<ITestResult>>> resultSet, BiConsumer<ITestContext, ITestResult> remove) {
        CSet<ITestResult> localCopy = new CSet<ITestResult>();
        for (Pair pair : resultSet) {
            for (ITestResult r : (CSet)pair.getValue()) {
                ITestResult match = localCopy.getFirstOrNull(l -> CTestReportUtil.isSameTestMethod(l, r));
                if (match != null) {
                    remove.accept((ITestContext)pair.getKey(), r);
                    continue;
                }
                localCopy.add(r);
            }
        }
    }

    private static void removeDuplicate(CSet<ITestResult> highPriorityResultSet, Map.Entry<ITestContext, CSet<ITestResult>> lowPriorityResultSet, BiConsumer<ITestContext, ITestResult> remove) {
        highPriorityResultSet.forEach(r -> {
            ITestResult match = ((CSet)lowPriorityResultSet.getValue()).getFirstOrNull(l -> CTestReportUtil.isSameTestMethod(l, r));
            if (match != null) {
                remove.accept((ITestContext)lowPriorityResultSet.getKey(), match);
            }
        });
    }

    private static boolean isSameTestMethod(ITestResult result1, ITestResult result2) {
        return result1.getInstanceName().equals(result2.getInstanceName()) && result1.getMethod().getMethodName().equals(result2.getMethod().getMethodName()) && (result1.getParameters() == null && result2.getParameters() == null || result1.getParameters().getClass().equals(result2.getParameters().getClass()));
    }
}

