/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.testng.utils;

import java.util.function.Consumer;
import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigs;
import org.catools.common.testng.listeners.CTestNGListener;
import org.catools.common.testng.utils.CTestClassUtil;
import org.catools.common.tests.CTest;
import org.catools.common.utils.CObjectUtil;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class CXmlSuiteUtils {
    public static XmlTest buildTestForIssueKeys(CTest testInstance, CSet<String> issueIds, String testName) {
        return CXmlSuiteUtils.buildTestForClasses(CTestClassUtil.getClassNameForIssueKeys(testInstance, issueIds), testName);
    }

    public static XmlSuite buildTestSuiteForClasses(CHashMap<String, CSet<String>> testClasses, String suiteName, Consumer<XmlSuite> xmlSuiteAdjuster) {
        CList<XmlTest> tests = testClasses.asSet().mapToList(e -> CXmlSuiteUtils.buildTestForClasses((CSet)e.getValue(), (String)e.getKey()));
        return CXmlSuiteUtils.buildTestSuiteForClasses(tests, suiteName, xmlSuiteAdjuster);
    }

    public static XmlTest buildTestForClasses(CSet<String> testClasses, String testName) {
        XmlTest xmlTest = new XmlTest();
        xmlTest.setJUnit(false);
        xmlTest.setName(testName);
        CList<String> listForSorting = testClasses.toList();
        listForSorting.sort(String::compareTo);
        xmlTest.setXmlClasses(listForSorting.mapToList(v -> new XmlClass(v)));
        return xmlTest;
    }

    public static XmlSuite buildTestSuiteForClasses(CList<XmlTest> tests, String suiteName, Consumer<XmlSuite> xmlSuiteAdjuster) {
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setParallel(XmlSuite.ParallelMode.CLASSES);
        xmlSuite.setThreadCount(CConfigs.TestNG.getThreadCount());
        xmlSuite.setName(suiteName);
        xmlSuite.setJUnit(Boolean.valueOf(false));
        xmlSuite.setAllowReturnValues(Boolean.valueOf(true));
        tests.forEach(test -> {
            test.setSuite(xmlSuite);
            xmlSuite.addTest(test);
        });
        xmlSuite.addListener(CTestNGListener.class.getName());
        if (xmlSuiteAdjuster != null) {
            xmlSuiteAdjuster.accept(xmlSuite);
        }
        return xmlSuite;
    }

    public static XmlSuite copy(XmlSuite xmlSuite, String suiteNamePostfix) {
        XmlSuite suite = CObjectUtil.clone(xmlSuite);
        suite.setName(suite.getName() + suiteNamePostfix);
        return suite;
    }
}

