/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.tests;

import org.catools.common.config.CConfigs;
import org.catools.common.extensions.verify.CVerificationInfo;
import org.catools.common.extensions.verify.CVerificationQueue;
import org.catools.common.extensions.verify.CVerify;
import org.catools.common.logger.CLogger;
import org.catools.common.testng.model.CExecutionStatus;
import org.catools.common.testng.model.CTestResult;
import org.catools.common.testng.utils.CTestClassUtil;
import org.catools.common.tests.CTestData;
import org.fusesource.jansi.AnsiConsole;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;

public abstract class CTest
implements CVerificationQueue<CVerify> {
    private static boolean FIRST_RUN_PREPARATION_CALLED = false;
    private CExecutionStatus testResult = CExecutionStatus.CREATED;
    private final CTestData dataState = new CTestData();
    private final String name = CTestClassUtil.getTestName(this.getClass());
    public final CLogger logger = new CLogger(this.name);
    public final CVerify verify = new CVerify(this.logger);
    private final String projectName = CConfigs.TestManagement.getProjectName();
    private final String versionName = CConfigs.TestManagement.getVersionName();

    public String getName() {
        return this.name;
    }

    public CTestData getDataState() {
        return this.dataState;
    }

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext context) {
        this.logger.debug("BeforeSuite Started for suite %s ", this.getSuiteName(context));
        if (!FIRST_RUN_PREPARATION_CALLED) {
            this.onFirstRun();
            FIRST_RUN_PREPARATION_CALLED = true;
        }
    }

    @BeforeTest(alwaysRun=true)
    public void beforeTest(ITestContext context) {
        this.logger.debug("BeforeTest Started for issue %s ", this.getContextName(context));
    }

    @BeforeClass(alwaysRun=true)
    public void beforeClass() {
        this.logger.debug("BeforeTest Finished for class %s ", this.name);
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(ITestResult result) {
        this.logger.debug("BeforeMethod Started for class %s, method %s", this.name, this.getMethodName(result));
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod(ITestResult result) {
        this.logger.debug("AfterMethod Started for class %s, method %s ", this.name, this.getMethodName(result));
        if (CConfigs.Core.isDataSetupModeOn()) {
            if (this.testResult == CExecutionStatus.CREATED && (result == null || result.getStatus() != 1)) {
                this.testResult = CExecutionStatus.SUCCESS;
                Reporter.getCurrentTestResult().setStatus(3);
            }
        } else {
            this.testResult = new CTestResult(this.projectName, this.versionName, result).getStatus();
        }
        if (result.getThrowable() != null) {
            this.logger.error("Test Failed With Exception:\n" + result.getThrowable(), new Object[0]);
        }
    }

    @AfterClass(alwaysRun=true)
    public void afterClass() {
        this.logger.debug("AfterClass Started for class %s", this.name);
        switch (this.testResult) {
            case SUCCESS: 
            case SUCCESS_PERCENTAGE_FAILURE: {
                this.onSuccess();
                break;
            }
            case SKIP: {
                this.onSkip();
                break;
            }
            case FAILURE: {
                this.onFailure();
                break;
            }
            case DEFERRED: {
                this.onDeferred();
                break;
            }
            case BLOCKED: {
                this.onBlocked();
                break;
            }
            case AWAITING: {
                this.onAwaiting();
            }
        }
    }

    @AfterTest(alwaysRun=true)
    public void afterTest(ITestContext context) {
        this.logger.debug("AfterTest Started for issue %s ", this.getContextName(context));
    }

    @AfterSuite(alwaysRun=true)
    public void afterSuite(ITestContext context) {
        this.logger.debug("AfterSuite Started for suite %s ", this.getSuiteName(context));
    }

    public void updateDataState(String key, Object value) {
        this.getDataState().updateDataState(key, value);
    }

    public Object getDataState(String key) {
        return this.getDataState().getDataState(key);
    }

    protected void onAwaiting() {
    }

    protected void onBlocked() {
    }

    protected void onDeferred() {
    }

    protected void onFailure() {
    }

    protected void onSkip() {
    }

    protected void onSuccess() {
    }

    protected void onFirstRun() {
    }

    private String getMethodName(ITestResult result) {
        if (result == null || result.getMethod() == null) {
            return "";
        }
        return result.getMethod().getMethodName();
    }

    private String getSuiteName(ITestContext context) {
        if (context == null || context.getSuite() == null) {
            return "";
        }
        return context.getSuite().getName();
    }

    private String getContextName(ITestContext context) {
        if (context == null || context.getCurrentXmlTest() == null) {
            return "";
        }
        return context.getCurrentXmlTest().getName();
    }

    @Override
    public CLogger getLogger() {
        return this.logger;
    }

    @Override
    public CVerify queue(CVerificationInfo verificationInfo) {
        return this.verify.queue(verificationInfo);
    }

    static {
        AnsiConsole.systemInstall();
    }
}

