/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.text;

import java.util.Arrays;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.exception.CInvalidRangeException;
import org.catools.common.utils.CRandomUtil;

public class CLoremIpsum {
    private static final CSet<String> specialChars = new CSet<String>((Iterable<String>)Arrays.asList("!?,;......".split("")));

    public static String getParagraph(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength, int minParagraphLength, int maxParagraphLength) {
        if (minParagraphLength > maxParagraphLength) {
            throw new CInvalidRangeException("Min paragraph length value must be smaller or equal to max paragraph length.");
        }
        if (minParagraphLength < 0) {
            throw new CInvalidRangeException("Both paragraph length range values must be non-negative.");
        }
        StringBuilder sb = new StringBuilder();
        int length = CRandomUtil.Int.getNext(minParagraphLength, maxParagraphLength);
        while (sb.toString().trim().length() < length) {
            sb.append(CLoremIpsum.getStatement(minWordLength, maxWordLength, minStatementLength, maxStatementLength).trim() + " ");
        }
        return sb.toString().trim().substring(0, length - 1) + (String)specialChars.getAny();
    }

    public static CList<String> getParagraphs(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength, int minParagraphLength, int maxParagraphLength, int count) {
        CList<String> sb = new CList<String>();
        while (count-- > 0) {
            sb.add(CLoremIpsum.getParagraph(minWordLength, maxWordLength, minStatementLength, maxStatementLength, minParagraphLength, maxParagraphLength));
        }
        return sb;
    }

    public static String getStatement(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength) {
        if (minStatementLength > maxStatementLength) {
            throw new CInvalidRangeException("Min statement length value must be smaller or equal to max statement length.");
        }
        if (minStatementLength < 0) {
            throw new CInvalidRangeException("Both statement length range values must be non-negative.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((String)new CList<String>("ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("")).getAny());
        int length = CRandomUtil.Int.getNext(minStatementLength, maxStatementLength);
        while (sb.toString().trim().length() < length) {
            sb.append(CLoremIpsum.getWord(minWordLength, maxWordLength) + " ");
        }
        return sb.toString().trim().substring(0, length - 1) + (String)specialChars.getAny();
    }

    public static CList<String> getStatements(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength, int count) {
        CList<String> sb = new CList<String>();
        while (count-- > 0) {
            sb.add(CLoremIpsum.getStatement(minWordLength, maxWordLength, minStatementLength, maxStatementLength));
        }
        return sb;
    }

    public static String getWord(int minWordLength, int maxWordLength) {
        if (minWordLength > maxWordLength) {
            throw new CInvalidRangeException("Min word length value must be smaller or equal to max word length.");
        }
        if (minWordLength < 0) {
            throw new CInvalidRangeException("Both word length range values must be non-negative.");
        }
        return new RandomStringGenerator.Builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).build().generate(minWordLength, maxWordLength);
    }

    public static CList<String> getWords(int minWordLength, int maxWordLength, int count) {
        CList<String> sb = new CList<String>();
        while (count-- > 0) {
            sb.add(CLoremIpsum.getWord(minWordLength, maxWordLength));
        }
        return sb;
    }
}

