/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.catools.common.collections.CList;
import org.catools.common.text.CStringUtil;

public class CRegExUtil
extends RegExUtils {
    public static final String ALPHANUMERIC_PATTERN = "^[0-9a-zA-Z]*$";
    public static final String NUMERIC_PATTERN = "^[\\d]*$";

    public static CList<String> groups(String input, Pattern pattern) {
        CList<String> matches = new CList<String>();
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            int i = 0;
            while (i++ < matcher.groupCount()) {
                matches.add(matcher.group(i));
            }
        }
        return matches;
    }

    public static boolean isAlphaNumeric(String input) {
        return CRegExUtil.isMatch(input, ALPHANUMERIC_PATTERN);
    }

    public static boolean isAlphaNumericSpace(String input) {
        return CStringUtil.isNotBlank((CharSequence)(input = CRegExUtil.removeAll((String)input, (String)"\\s+"))) && CRegExUtil.isMatch(input, ALPHANUMERIC_PATTERN);
    }

    public static boolean isMatch(String input, String pattern) {
        return CRegExUtil.isMatch(input, Pattern.compile(pattern));
    }

    public static boolean isMatch(String input, Pattern pattern) {
        return pattern.matcher(CStringUtil.defaultString((String)input)).find();
    }

    public static boolean isNumeric(String input) {
        return CRegExUtil.isMatch(input, NUMERIC_PATTERN);
    }
}

