/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.text.match;

import java.util.LinkedList;
import java.util.List;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CAnsiColor;
import org.fusesource.jansi.Ansi;

public class CStringDiff {
    private static final int DIFF_EDIT_COST = CConfigs.StringDiff.getDiffEditCost();

    public static String prettyDiff(String original, String text2) {
        return CStringDiff.prettyDiff(original, text2, DIFF_EDIT_COST);
    }

    public static String prettyDiff(String original, String text2, int diffEditCost) {
        LinkedList<DiffMatchPatch.Diff> diff = CStringDiff.diff(original, text2, diffEditCost);
        if (diff.isEmpty()) {
            return "";
        }
        return CStringDiff.diffPrettyFormat(diff, CConfigs.StringDiff.getEqualFormat(), CConfigs.StringDiff.getDeleteFormat(), CConfigs.StringDiff.getInsertFormat());
    }

    public static String coloredDiff(String original, String text2) {
        return CStringDiff.coloredDiff(original, text2, DIFF_EDIT_COST);
    }

    public static String coloredDiff(String original, String text2, int diffEditCost) {
        LinkedList<DiffMatchPatch.Diff> diffs = CStringDiff.diff(original, text2, diffEditCost);
        if (diffs.isEmpty()) {
            return "";
        }
        return CStringDiff.coloredDiff(diffs, CConfigs.StringDiff.getEqualColor(), CConfigs.StringDiff.getDeleteColor(), CConfigs.StringDiff.getInsertColor());
    }

    public static LinkedList<DiffMatchPatch.Diff> diff(String original, String text2) {
        return CStringDiff.diff(original, text2, DIFF_EDIT_COST);
    }

    public static LinkedList<DiffMatchPatch.Diff> diff(String original, String text2, int diffEditCost) {
        DiffMatchPatch diffMatchPatch = new DiffMatchPatch();
        diffMatchPatch.diffEditCost = (short)diffEditCost;
        LinkedList diffs = diffMatchPatch.diffMain(original, text2);
        diffMatchPatch.diffCleanupEfficiency(diffs);
        return diffs;
    }

    public static String diffPrettyFormat(List<DiffMatchPatch.Diff> diffs, String equalFormat, String deleteFormat, String insertFormat) {
        StringBuilder output = new StringBuilder();
        for (DiffMatchPatch.Diff diff : diffs) {
            switch (diff.operation) {
                case INSERT: {
                    output.append(CAnsiColor.toBlue(String.format(insertFormat, diff.text), new Object[0]));
                    break;
                }
                case DELETE: {
                    output.append(CAnsiColor.toRed(String.format(deleteFormat, diff.text), new Object[0]));
                    break;
                }
                case EQUAL: {
                    output.append(String.format(equalFormat, diff.text));
                }
            }
        }
        return output.toString();
    }

    public static String coloredDiff(List<DiffMatchPatch.Diff> diffs, Ansi.Color equalForeground, Ansi.Color deleteForeground, Ansi.Color insertForeground) {
        return CStringDiff.coloredDiff(diffs, Ansi.Color.DEFAULT, equalForeground, Ansi.Color.DEFAULT, deleteForeground, Ansi.Color.DEFAULT, insertForeground);
    }

    public static String coloredDiff(List<DiffMatchPatch.Diff> diffs, Ansi.Color equalBackground, Ansi.Color equalForeground, Ansi.Color deleteBackground, Ansi.Color deleteForeground, Ansi.Color insertBackground, Ansi.Color insertForeground) {
        StringBuilder output = new StringBuilder();
        for (DiffMatchPatch.Diff diff : diffs) {
            switch (diff.operation) {
                case INSERT: {
                    output.append(CAnsiColor.encode(diff.text, Ansi.Attribute.INTENSITY_BOLD, insertForeground, insertBackground));
                    break;
                }
                case DELETE: {
                    output.append(CAnsiColor.encode(diff.text, Ansi.Attribute.INTENSITY_BOLD, deleteForeground, deleteBackground));
                    break;
                }
                case EQUAL: {
                    output.append(CAnsiColor.encode(diff.text, Ansi.Attribute.INTENSITY_BOLD, equalForeground, equalBackground));
                }
            }
        }
        return output.toString();
    }
}

