/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.text.match;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.catools.common.text.match.CStringMatchInfo;
import org.catools.common.text.match.CStringMatchUtil;

public class CStringMatch {
    public static <T> CStringMatchInfo getBestMatch(T actual, List<T> matches, Function<T, String> toStrFunc, int acceptableMatchValue) {
        return CStringMatch.getMatches(actual, matches, toStrFunc, acceptableMatchValue).stream().sorted((o1, o2) -> (int)((o2.getPercent() - o1.getPercent()) * 1000.0)).findFirst().orElse(null);
    }

    public static <T> List<CStringMatchInfo<T>> getMatches(T actual, List<T> matches, Function<T, String> toStrFunc, int acceptableMatchValue) {
        ArrayList<CStringMatchInfo<T>> matchInfo = new ArrayList<CStringMatchInfo<T>>();
        for (T match : matches) {
            matchInfo.add(CStringMatch.getMatch(actual, match, toStrFunc, acceptableMatchValue));
        }
        return matchInfo.stream().filter(m -> m.getPercent() >= (double)acceptableMatchValue).collect(Collectors.toList());
    }

    public static <T> CStringMatchInfo<T> getMatch(T actual, T match, Function<T, String> toStrFunc, int acceptableMatchValue) {
        if (StringUtils.equals((CharSequence)toStrFunc.apply(actual), (CharSequence)toStrFunc.apply(match))) {
            return new CStringMatchInfo<T>(actual, match, 100.0);
        }
        double calcResult = CStringMatchUtil.calculateMatchValue(toStrFunc.apply(actual), toStrFunc.apply(match));
        return new CStringMatchInfo<T>(actual, match, calcResult >= (double)acceptableMatchValue ? calcResult : 0.0);
    }
}

