/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.text.match;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.catools.common.text.match.CMatchPairInfo;
import org.catools.common.text.match.CStringMatchUtil;

public class CStringMatchPair {
    public static <A, M> List<CMatchPairInfo<A, M>> getMatches(A actual, List<M> matches, Function<A, String> toStrFuncA, Function<M, String> toStrFuncM, int acceptableMatchValue) {
        ArrayList<CMatchPairInfo<A, M>> matchInfo = new ArrayList<CMatchPairInfo<A, M>>();
        for (M match : matches) {
            matchInfo.add(CStringMatchPair.getMatch(actual, match, toStrFuncA, toStrFuncM, acceptableMatchValue));
        }
        return matchInfo.stream().filter(m -> m.getPercent() >= (double)acceptableMatchValue).collect(Collectors.toList());
    }

    public static <A, M> CMatchPairInfo<A, M> getBestMatch(A actual, List<M> matches, Function<A, String> toStrFuncA, Function<M, String> toStrFuncM, int acceptableMatchValue) {
        return CStringMatchPair.getMatches(actual, matches, toStrFuncA, toStrFuncM, acceptableMatchValue).stream().sorted((o1, o2) -> (int)((o2.getPercent() - o1.getPercent()) * 1000.0)).findFirst().orElse(null);
    }

    public static <A, M> CMatchPairInfo<A, M> getMatch(A actual, M match, Function<A, String> toStrFuncA, Function<M, String> toStrFuncM, int acceptableMatchValue) {
        String m;
        String a = toStrFuncA.apply(actual);
        if (StringUtils.equals((CharSequence)a, (CharSequence)(m = toStrFuncM.apply(match)))) {
            return new CMatchPairInfo<A, M>(actual, match, 100.0);
        }
        double calcResult = CStringMatchUtil.calculateMatchValue(a, m);
        return new CMatchPairInfo<A, M>(actual, match, calcResult >= (double)acceptableMatchValue ? calcResult : 0.0);
    }
}

