/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.utils;

import java.util.Objects;
import java.util.function.Predicate;

public class CIterableUtil {
    public static <E> boolean containsAll(Iterable<E> iterable1, Iterable<E> iterable2) {
        if (iterable1 == null || iterable2 == null) {
            return iterable1 == iterable2;
        }
        for (E t : iterable2) {
            if (CIterableUtil.contains(iterable1, t)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean contains(Iterable<E> iterable, E e) {
        if (e == null) {
            return false;
        }
        for (E a : iterable) {
            if (!Objects.equals(a, e)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(Iterable iterable) {
        return iterable != null && iterable.iterator() != null && iterable.iterator().hasNext();
    }

    public static boolean isEmpty(Iterable iterable) {
        return !CIterableUtil.isNotEmpty(iterable);
    }

    public static <E> Boolean has(Iterable<E> iterable, Predicate<E> expected) {
        for (E a : iterable) {
            if (!expected.test(a)) continue;
            return true;
        }
        return false;
    }
}

