/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.utils;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigs;
import org.catools.common.exception.CInvalidRangeException;
import org.catools.common.io.CResource;
import org.catools.common.text.CLoremIpsum;

public class CRandomUtil {
    private static final Random RANDOM = new Random();

    public static class PersonName {
        private static final CSet<java.lang.String> usedSurNames = new CSet();
        private static final CSet<java.lang.String> usedMaleNames = new CSet();
        private static final CSet<java.lang.String> usedFemaleNames = new CSet();
        private static final CSet<java.lang.String> usedTitles = new CSet();
        private static final CSet<java.lang.String> surNames = new CSet<java.lang.String>((Iterable<java.lang.String>)new CResource("name_generator/usa_surnames.txt", CRandomUtil.class).getLines());
        private static final CSet<java.lang.String> maleNames = new CSet<java.lang.String>((Iterable<java.lang.String>)new CResource("name_generator/usa_male_names.txt", CRandomUtil.class).getLines());
        private static final CSet<java.lang.String> femaleNames = new CSet<java.lang.String>((Iterable<java.lang.String>)new CResource("name_generator/usa_female_names.txt", CRandomUtil.class).getLines());
        private static final CSet<java.lang.String> titles = new CSet<java.lang.String>((Iterable<java.lang.String>)new CResource("name_generator/usa_titles.txt", CRandomUtil.class).getLines());

        public static java.lang.String nextFirstName() {
            return PersonName.nextFirstName(Int.getNext() % 2 == 0);
        }

        public static java.lang.String nextFirstName(boolean male) {
            if (male) {
                return PersonName.getFromList(maleNames, usedMaleNames);
            }
            return PersonName.getFromList(femaleNames, usedFemaleNames);
        }

        public static java.lang.String nextLastName() {
            return PersonName.getFromList(surNames, usedSurNames);
        }

        public static java.lang.String nextName() {
            return PersonName.nextName(Int.getNext() % 2 == 0, Int.getNext() % 2 == 0);
        }

        public static java.lang.String nextName(boolean male, boolean withTitle) {
            return (java.lang.String)(withTitle ? PersonName.nextTitle() + " " : "") + PersonName.nextFirstName(male) + " " + PersonName.nextLastName();
        }

        public static java.lang.String nextNameWithMiddle() {
            return PersonName.nextNameWithMiddle(Int.getNext() % 2 == 0, Int.getNext() % 2 == 0);
        }

        public static java.lang.String nextNameWithMiddle(boolean male, boolean withTitle) {
            return (java.lang.String)(withTitle ? PersonName.nextTitle() + " " : "") + PersonName.nextFirstName(male) + " " + PersonName.nextFirstName(male) + " " + PersonName.nextLastName();
        }

        public static java.lang.String nextTitle() {
            return PersonName.getFromList(titles, usedTitles);
        }

        private static synchronized java.lang.String getFromList(CSet<java.lang.String> mainList, CSet<java.lang.String> usedList) {
            if (mainList.isEmpty()) {
                mainList.addAll(usedList);
                usedList.clear();
            }
            java.lang.String anyAndRemove = (java.lang.String)mainList.getAnyAndRemove();
            usedList.add(anyAndRemove);
            return anyAndRemove.trim();
        }
    }

    public static class PhoneNumber {
        public static java.lang.String nextNumber(java.lang.String countryCode) {
            java.lang.String prefix;
            int numberLength = 7;
            switch (countryCode) {
                case "US": {
                    prefix = "603";
                    break;
                }
                case "CA": {
                    prefix = "204";
                    break;
                }
                case "GB": {
                    prefix = "345";
                    break;
                }
                default: {
                    java.lang.String numb = java.lang.String.valueOf(PhoneNumberUtil.getInstance().getExampleNumber(countryCode).getNationalNumber());
                    prefix = numb.substring(0, 4);
                    numberLength = numb.length() - 4;
                }
            }
            return prefix + RandomStringUtils.random((int)numberLength, (java.lang.String)"2345678");
        }
    }

    public static class String {
        public static java.lang.String randomNumeric(int length) {
            if (length < 1) {
                throw new CInvalidRangeException("The length value should be greater than 0. length:" + length);
            }
            return RandomUtils.nextInt((int)1, (int)9) + RandomStringUtils.randomNumeric((int)length).substring(1);
        }

        public static java.lang.String randomNumeric(int minLengthInclusive, int maxLengthExclusive) {
            if (minLengthInclusive < 1) {
                throw new CInvalidRangeException("The minLengthInclusive value should be greater than 0. minLengthInclusive:" + minLengthInclusive);
            }
            if (maxLengthExclusive < minLengthInclusive) {
                throw new CInvalidRangeException("The maxLengthExclusive should be equal or greater than minLengthInclusive. maxLengthExclusive:" + maxLengthExclusive + ", minLengthInclusive:" + minLengthInclusive);
            }
            return RandomUtils.nextInt((int)1, (int)9) + RandomStringUtils.randomNumeric((int)minLengthInclusive, (int)maxLengthExclusive).substring(1);
        }

        public static java.lang.String nextParagraph() {
            return String.nextParagraph(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), CConfigs.LoremIpsum.getDefaultMinStatementLength(), CConfigs.LoremIpsum.getDefaultMaxStatementLength(), CConfigs.LoremIpsum.getDefaultMinParagraphLength(), CConfigs.LoremIpsum.getDefaultMaxParagraphLength());
        }

        public static java.lang.String nextParagraph(int minParagraphLength, int maxParagraphLength) {
            return String.nextParagraph(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), CConfigs.LoremIpsum.getDefaultMinStatementLength(), CConfigs.LoremIpsum.getDefaultMaxStatementLength(), minParagraphLength, maxParagraphLength);
        }

        public static java.lang.String nextParagraph(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength, int minParagraphLength, int maxParagraphLength) {
            return CLoremIpsum.getParagraph(minWordLength, maxWordLength, minStatementLength, maxStatementLength, minParagraphLength, maxParagraphLength);
        }

        public static CList<java.lang.String> nextParagraphs(int count) {
            return String.nextParagraphs(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), CConfigs.LoremIpsum.getDefaultMinStatementLength(), CConfigs.LoremIpsum.getDefaultMaxStatementLength(), CConfigs.LoremIpsum.getDefaultMinParagraphLength(), CConfigs.LoremIpsum.getDefaultMaxParagraphLength(), count);
        }

        public static CList<java.lang.String> nextParagraphs(int minParagraphLength, int maxParagraphLength, int count) {
            return String.nextParagraphs(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), CConfigs.LoremIpsum.getDefaultMinStatementLength(), CConfigs.LoremIpsum.getDefaultMaxStatementLength(), minParagraphLength, maxParagraphLength, count);
        }

        public static CList<java.lang.String> nextParagraphs(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength, int minParagraphLength, int maxParagraphLength, int count) {
            return CLoremIpsum.getParagraphs(minWordLength, maxWordLength, minStatementLength, maxStatementLength, minParagraphLength, maxParagraphLength, count);
        }

        public static java.lang.String nextStatement() {
            return String.nextStatement(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), CConfigs.LoremIpsum.getDefaultMinStatementLength(), CConfigs.LoremIpsum.getDefaultMaxStatementLength());
        }

        public static java.lang.String nextStatement(int minStatementLength, int maxStatementLength) {
            return String.nextStatement(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), minStatementLength, maxStatementLength);
        }

        public static java.lang.String nextStatement(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength) {
            return CLoremIpsum.getStatement(minWordLength, maxWordLength, minStatementLength, maxStatementLength);
        }

        public static CList<java.lang.String> nextStatements(int count) {
            return String.nextStatements(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), CConfigs.LoremIpsum.getDefaultMinStatementLength(), CConfigs.LoremIpsum.getDefaultMaxStatementLength(), count);
        }

        public static CList<java.lang.String> nextStatements(int minStatementLength, int maxStatementLength, int count) {
            return String.nextStatements(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), minStatementLength, maxStatementLength, count);
        }

        public static CList<java.lang.String> nextStatements(int minWordLength, int maxWordLength, int minStatementLength, int maxStatementLength, int count) {
            return CLoremIpsum.getStatements(minWordLength, maxWordLength, minStatementLength, maxStatementLength, count);
        }

        public static java.lang.String nextWord() {
            return String.nextWord(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength());
        }

        public static java.lang.String nextWord(int minWordLength, int maxWordLength) {
            return CLoremIpsum.getWord(minWordLength, maxWordLength);
        }

        public static CList<java.lang.String> nextWords(int count) {
            return String.nextWords(CConfigs.LoremIpsum.getDefaultMinWordLength(), CConfigs.LoremIpsum.getDefaultMaxWordLength(), count);
        }

        public static CList<java.lang.String> nextWords(int minWordLength, int maxWordLength, int count) {
            return CLoremIpsum.getWords(minWordLength, maxWordLength, count);
        }
    }

    public static class Float {
        public static float getNext(float startInclusive, float endInclusive) {
            if (startInclusive > endInclusive) {
                throw new CInvalidRangeException("Start value must be smaller or equal to end value.");
            }
            if (startInclusive < 0.0f) {
                throw new CInvalidRangeException("Start value must be positive integer.");
            }
            if (startInclusive == endInclusive) {
                return startInclusive;
            }
            return startInclusive + (endInclusive - startInclusive) * RANDOM.nextFloat();
        }

        public static float getNext() {
            return Float.getNext(0.0f, java.lang.Float.MAX_VALUE);
        }
    }

    public static class Double {
        public static double getNext(double startInclusive, double endInclusive) {
            if (startInclusive > endInclusive) {
                throw new CInvalidRangeException("Start value must be smaller or equal to end value.");
            }
            if (startInclusive < 0.0) {
                throw new CInvalidRangeException("Start value must be positive integer.");
            }
            if (startInclusive == endInclusive) {
                return startInclusive;
            }
            return startInclusive + (endInclusive - startInclusive) * RANDOM.nextDouble();
        }

        public static double getNext() {
            return Double.getNext(0.0, java.lang.Double.MAX_VALUE);
        }
    }

    public static class Long {
        public static long getNext(long startInclusive, long endExclusive) {
            if (startInclusive > endExclusive) {
                throw new CInvalidRangeException("Start value must be smaller or equal to end value.");
            }
            if (startInclusive < 0L) {
                throw new CInvalidRangeException("Start value must be positive integer.");
            }
            if (startInclusive == endExclusive) {
                return startInclusive;
            }
            return (long)Double.getNext(startInclusive, endExclusive);
        }

        public static long getNext() {
            return Long.getNext(0L, java.lang.Long.MAX_VALUE);
        }
    }

    public static class Int {
        public static int getNext(int startInclusive, int endExclusive) {
            if (startInclusive > endExclusive) {
                throw new CInvalidRangeException("Start value must be smaller or equal to end value.");
            }
            if (startInclusive < 0) {
                throw new CInvalidRangeException("Start value must be positive integer.");
            }
            if (startInclusive == endExclusive) {
                return startInclusive;
            }
            return startInclusive + RANDOM.nextInt(endExclusive - startInclusive);
        }

        public static int getNext() {
            return Int.getNext(0, Integer.MAX_VALUE);
        }
    }
}

