/*
 * Decompiled with CFR 0.152.
 */
package org.catools.etl.zapi;

import java.util.Collection;
import java.util.Date;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.concurrent.CParallelRunner;
import org.catools.common.date.CDate;
import org.catools.common.exception.CRuntimeException;
import org.catools.common.text.CStringUtil;
import org.catools.etl.cache.CEtlCacheManager;
import org.catools.etl.dao.CEtlCycleDao;
import org.catools.etl.dao.CEtlExecutionDao;
import org.catools.etl.dao.CEtlLastSyncDao;
import org.catools.etl.model.CEtlCycles;
import org.catools.etl.model.CEtlExecutionStatus;
import org.catools.etl.model.CEtlExecutions;
import org.catools.etl.zapi.translators.CEtlZApiTranslator;
import org.catools.zapi.CZApiClient;
import org.catools.zapi.model.CZApiCycles;
import org.catools.zapi.model.CZApiExecutions;
import org.catools.zapi.model.CZApiProject;
import org.catools.zapi.model.CZApiProjects;
import org.catools.zapi.model.CZApiVersion;
import org.catools.zapi.model.CZApiVersions;
import org.slf4j.Logger;

public class CEtlZApiSyncClient {
    private static final String ZAPI = "ZAPI";
    private static final String UNSCHEDULED = "Unscheduled";

    public static void syncZephyr(Logger logger, CSet<String> projectNamesToSync, int parallelInputCount, int parallelOutputCount) {
        CZApiProjects projects = CZApiClient.Project.getProjects();
        CZApiClient.ExecutionStatus.getExecutionStatus().forEach(ex -> CEtlCacheManager.readExecutionStatus((Logger)logger, (CEtlExecutionStatus)new CEtlExecutionStatus(String.valueOf(ex.getId()), ex.getName())));
        CDate syncStartTime = CDate.now();
        for (CZApiProject project : projects.getAll(p -> projectNamesToSync.contains((Object)p.getName()))) {
            CZApiVersions projectVersions = CZApiClient.Version.getProjectVersions(project).getAllVersions();
            projectVersions.removeIf(v -> CStringUtil.containsIgnoreCase((CharSequence)UNSCHEDULED, (CharSequence)v.getName()));
            Date projectLastZApiSync = CEtlLastSyncDao.getProjectLastSync((Logger)logger, (String)ZAPI, (String)project.getName());
            if (projectLastZApiSync != null) {
                CZApiExecutions executions = CZApiClient.Search.getExecutions(String.format("project='%s'", project.getName()), projectLastZApiSync, parallelInputCount, parallelOutputCount, null);
                CSet versionsToUpdate = executions.mapToSet(e -> e.getVersionName());
                projectVersions.removeIf(v -> !versionsToUpdate.contains((Object)v.getName()));
            }
            for (CZApiVersion version : projectVersions) {
                CZApiCycles cycles = CZApiClient.Cycle.getAllCycle(new CZApiProject().setId(project.getId()).setName(project.getName()), new CZApiVersion().setId(version.getId()).setName(version.getName()));
                if (!cycles.isNotEmpty()) continue;
                CEtlCycleDao.mergeCycles((Logger)logger, (CEtlCycles)CEtlZApiTranslator.translateCycles(logger, cycles));
                CEtlZApiSyncClient.addExecutions(logger, project.getName(), version.getName(), parallelInputCount, parallelOutputCount);
            }
            CEtlLastSyncDao.updateProjectLastSync((Logger)logger, (String)ZAPI, (String)project.getName(), (Date)syncStartTime);
        }
    }

    private static void addExecutions(Logger logger, String projectName, String versionName, int parallelInputCount, int parallelOutputCount) {
        Date lastSync = CEtlLastSyncDao.getExecutionLastSync((Logger)logger, (String)ZAPI, (String)projectName, (String)versionName);
        String zql = String.format("project='%s' AND fixVersion = \"%s\"", projectName, versionName);
        CDate syncStartTime = CDate.now();
        CEtlExecutions executions = new CEtlExecutions();
        CZApiClient.Search.getExecutions(zql, lastSync, parallelInputCount, parallelOutputCount, zApiExecutions -> {
            if (zApiExecutions.isNotEmpty()) {
                zApiExecutions.removeIf(e -> !projectName.equalsIgnoreCase(e.getProjectName()) || !versionName.equalsIgnoreCase(e.getVersionName()));
                if (zApiExecutions.isNotEmpty()) {
                    CEtlExecutions translatedExecutions = CEtlZApiTranslator.translateExecutions(logger, zApiExecutions);
                    logger.info("{} execution records translated to {} etl execution records", (Object)zApiExecutions.size(), (Object)translatedExecutions.size());
                    CEtlExecutions cEtlExecutions = executions;
                    synchronized (cEtlExecutions) {
                        executions.addAll((Collection)translatedExecutions);
                        logger.info("{} executions translated.", (Object)executions.size());
                    }
                }
            }
        });
        logger.info("Total number of translate executions are {}", (Object)executions.size());
        if (executions.isNotEmpty()) {
            try {
                int partitionSize = executions.size() < parallelOutputCount ? executions.size() : executions.size() / parallelOutputCount;
                CList partitions = executions.partition(partitionSize);
                new CParallelRunner("Merge Executions", Math.min(partitions.size(), parallelOutputCount), () -> {
                    while (true) {
                        CEtlExecutions executionsPartition = null;
                        CList cList = partitions;
                        synchronized (cList) {
                            if (partitions.isNotEmpty()) {
                                executionsPartition = new CEtlExecutions((Iterable)partitions.remove(0));
                            }
                        }
                        if (executionsPartition == null) break;
                        CEtlExecutionDao.mergeExecutions((Logger)logger, (CEtlExecutions)executionsPartition);
                    }
                    return true;
                }).invokeAll();
            }
            catch (Throwable t) {
                throw new CRuntimeException("Failed to persist test execution.", t);
            }
        }
        CEtlLastSyncDao.updateExecutionLastSync((Logger)logger, (String)ZAPI, (String)projectName, (String)versionName, (Date)syncStartTime);
    }
}

