/*
 * Decompiled with CFR 0.152.
 */
package org.catools.etl.zapi.translators;

import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.api.domain.Version;
import java.util.Date;
import org.catools.common.text.CStringUtil;
import org.catools.etl.dao.CEtlCycleDao;
import org.catools.etl.dao.CEtlExecutionStatusDao;
import org.catools.etl.dao.CEtlItemDao;
import org.catools.etl.dao.CEtlProjectDao;
import org.catools.etl.dao.CEtlUserDao;
import org.catools.etl.dao.CEtlVersionDao;
import org.catools.etl.jira.translators.CEtlJiraTranslator;
import org.catools.etl.model.CEtlCycle;
import org.catools.etl.model.CEtlCycles;
import org.catools.etl.model.CEtlExecution;
import org.catools.etl.model.CEtlExecutionStatus;
import org.catools.etl.model.CEtlExecutions;
import org.catools.etl.model.CEtlItem;
import org.catools.etl.model.CEtlProject;
import org.catools.etl.model.CEtlUser;
import org.catools.etl.model.CEtlVersion;
import org.catools.etl.model.CEtlVersions;
import org.catools.jira.client.CJiraClient;
import org.catools.zapi.CZApiClient;
import org.catools.zapi.model.CZApiCycle;
import org.catools.zapi.model.CZApiCycles;
import org.catools.zapi.model.CZApiExecution;
import org.catools.zapi.model.CZApiExecutions;
import org.slf4j.Logger;

public class CEtlZApiTranslator {
    public static CEtlCycles translateCycles(Logger logger, CZApiCycles cycles) {
        return new CEtlCycles((Iterable)cycles.mapToSet(c -> CEtlZApiTranslator.translateCycle(logger, c)));
    }

    public static CEtlCycle translateCycle(Logger logger, CZApiCycle cycle) {
        try {
            CEtlProject project = CEtlProjectDao.getProjects((Logger)logger).getByName(cycle.getProject().getName());
            CEtlVersion version = CEtlVersionDao.getVersion((Logger)logger, (CEtlProject)project, (String)cycle.getVersion().getName());
            if (version == null) {
                CEtlVersions versions = new CEtlVersions();
                for (Version projectVersion : CJiraClient.getProjectVersions((String)project.getId())) {
                    versions.add((Object)CEtlJiraTranslator.translateVersion((CEtlProject)project, (Version)projectVersion));
                }
                CEtlVersionDao.mergeVersions((Logger)logger, (CEtlVersions)versions);
                version = CEtlVersionDao.getVersion((Logger)logger, (CEtlProject)project, (String)cycle.getVersion().getName());
            }
            return new CEtlCycle(String.valueOf(cycle.getId()), cycle.getName(), cycle.getDescription(), version, cycle.getEnvironment(), (Date)cycle.getEndDate(), cycle.getBuild(), (Date)cycle.getStartDate());
        }
        catch (Throwable t) {
            logger.error("Failed to translate cycle.", t);
            throw t;
        }
    }

    public static CEtlExecutions translateExecutions(Logger logger, CZApiExecutions executions) {
        return new CEtlExecutions((Iterable)executions.mapToSet(i -> CEtlZApiTranslator.translateExecution(logger, i)));
    }

    public static CEtlExecution translateExecution(Logger logger, CZApiExecution execution) {
        CEtlExecutionStatus status = CEtlExecutionStatusDao.getStatusByName((Logger)logger, (String)execution.getExecutionStatus());
        CEtlItem item = CEtlItemDao.getItemById((Logger)logger, (String)execution.getIssueKey());
        CEtlCycle cycle = CEtlCycleDao.getCycleById((Logger)logger, (String)String.valueOf(execution.getCycleId()));
        CEtlUser executor = CEtlZApiTranslator.getExecutor(logger, execution);
        if (cycle == null && execution.getCycleId() != null) {
            cycle = CEtlZApiTranslator.translateCycle(logger, CZApiClient.Cycle.getCycleById(execution.getCycleId().longValue()));
            CEtlCycleDao.mergeCycle((Logger)logger, (CEtlCycle)cycle);
        }
        return new CEtlExecution(String.valueOf(execution.getId()), item, cycle, (Date)execution.getCreatedOn(), (Date)execution.getExecutedOn(), executor, status, execution.getExecutionDefectCount(), execution.getStepDefectCount(), execution.getTotalDefectCount(), execution.getComment());
    }

    protected static CEtlUser getExecutor(Logger logger, CZApiExecution execution) {
        if (CStringUtil.isNotBlank((CharSequence)execution.getExecutedByUserName())) {
            CEtlUser executor = CEtlUserDao.getUserByName((Logger)logger, (String)execution.getExecutedByUserName());
            if (executor == null) {
                CEtlZApiTranslator.addNewUser(logger, execution);
                executor = CEtlUserDao.getUserByName((Logger)logger, (String)execution.getExecutedByUserName());
            }
            return executor;
        }
        return null;
    }

    private static synchronized void addNewUser(Logger logger, CZApiExecution execution) {
        User user = CJiraClient.getUser((String)execution.getExecutedByUserName());
        CEtlUserDao.mergeUser((Logger)logger, (CEtlUser)new CEtlUser(user.getName(), user.getEmailAddress(), user.getDisplayName()));
    }
}

