/*
 * Decompiled with CFR 0.152.
 */
package org.cddcore.engine.builder;

import org.cddcore.engine.AssertionException$;
import org.cddcore.engine.CameToWrongConclusionScenarioException$;
import org.cddcore.engine.CodeDoesntProduceExpectedException$;
import org.cddcore.engine.ExceptionThrownInAssertion$;
import org.cddcore.engine.NoExpectedException$;
import org.cddcore.engine.Reportable$;
import org.cddcore.engine.Scenario;
import org.cddcore.engine.ScenarioShouldHaveCodeIfExpectsException$;
import org.cddcore.engine.builder.DecisionTree;
import org.cddcore.engine.builder.EvaluateTree;
import org.cddcore.engine.builder.MakeClosures;
import org.cddcore.engine.builder.ValidateScenario;
import org.cddcore.utilities.CddDisplayProcessor;
import org.cddcore.utilities.CddDisplayProcessor$;
import org.cddcore.utilities.CodeHolder;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

public abstract class ValidateScenario$class {
    public static Scenario preValidateScenario(ValidateScenario $this, MakeClosures mc, Scenario s, CddDisplayProcessor ldp) {
        if (s.expected().isDefined()) {
            $this.checkBecause(mc, s, ldp);
            return $this.checkHasExpected(s);
        }
        throw NoExpectedException$.MODULE$.apply(s, NoExpectedException$.MODULE$.apply$default$2(), ldp);
    }

    public static void postValidateScenario(ValidateScenario $this, EvaluateTree evaluateTree, DecisionTree tree, Scenario s, CddDisplayProcessor ldp) {
        $this.checkHaveCodeIfHaveExpectException(s);
        $this.checkCodeComesToExpected(evaluateTree, s);
        $this.checkAssertions(evaluateTree, tree, s);
        $this.checkCorrectValue(evaluateTree, tree, s);
    }

    public static Scenario checkHasExpected(ValidateScenario $this, Scenario s) {
        if (s.expected().isEmpty()) {
            throw NoExpectedException$.MODULE$.apply(s, NoExpectedException$.MODULE$.apply$default$2(), CddDisplayProcessor$.MODULE$.cdp());
        }
        return s;
    }

    public static void checkHaveCodeIfHaveExpectException(ValidateScenario $this, Scenario s) {
        Tuple2 tuple2 = new Tuple2(s.expected(), s.code());
        if (tuple2 != null) {
            Some some;
            Either either;
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some && (either = (Either)(some = (Some)option).x()) instanceof Left) {
                None$ none$ = None$.MODULE$;
                Option option3 = option2;
                if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                    throw ScenarioShouldHaveCodeIfExpectsException$.MODULE$.apply(s);
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkCodeComesToExpected(ValidateScenario $this, EvaluateTree evaluateTree, Scenario s) {
        Tuple2 tuple2 = new Tuple2(s.code(), s.expected());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                CodeHolder code = (CodeHolder)some.x();
                if (option2 instanceof Some) {
                    Either actual;
                    Some some2 = (Some)option2;
                    Either expected2 = (Either)some2.x();
                    if (!Reportable$.MODULE$.compareAllowingExceptionToBeMoreSpecific(expected2, actual = evaluateTree.makeClosures().safeEvaluateResult(code.fn(), s))) throw CodeDoesntProduceExpectedException$.MODULE$.apply(s, actual, CodeDoesntProduceExpectedException$.MODULE$.apply$default$3(), CddDisplayProcessor$.MODULE$.cdp());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void checkAssertions(ValidateScenario $this, EvaluateTree evaluateTree, DecisionTree tree, Scenario s) {
        s.assertions().foreach((Function1)new Serializable($this, evaluateTree, tree, s){
            public static final long serialVersionUID = 0L;
            private final EvaluateTree evaluateTree$1;
            private final DecisionTree tree$1;
            private final Scenario s$1;

            public final void apply(CodeHolder<Function2<Params, Either<Exception, R>, Object>> a) {
                block2: {
                    Either<Exception, R> result = this.evaluateTree$1.safeEvaluate(this.tree$1, this.s$1);
                    try {
                        boolean assertionResult = BoxesRunTime.unboxToBoolean((Object)a.fn().apply(this.s$1.params(), result));
                        if (!assertionResult) break block2;
                        return;
                    }
                    catch (Exception exception) {
                        throw ExceptionThrownInAssertion$.MODULE$.apply(this.s$1, a, exception);
                    }
                }
                throw AssertionException$.MODULE$.apply(a, this.s$1, CddDisplayProcessor$.MODULE$.cdp());
            }
            {
                void var4_4;
                void var3_3;
                this.evaluateTree$1 = evaluateTree$1;
                this.tree$1 = var3_3;
                this.s$1 = var4_4;
            }
        });
    }

    public static void checkCorrectValue(ValidateScenario $this, EvaluateTree evaluateTree, DecisionTree tree, Scenario s) {
        Either actual = evaluateTree.safeEvaluate(tree, s);
        Option option = s.expected();
        if (option instanceof Some) {
            Some some = (Some)option;
            Either ex = (Either)some.x();
            if (Reportable$.MODULE$.compareAllowingExceptionToBeMoreSpecific(ex, actual)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            Either either = actual;
            if (either instanceof Left) {
                Left left = (Left)either;
                Exception cause = (Exception)left.a();
                throw CameToWrongConclusionScenarioException$.MODULE$.apply(ex, actual, s, cause, CddDisplayProcessor$.MODULE$.cdp());
            }
            throw CameToWrongConclusionScenarioException$.MODULE$.apply(ex, actual, s, null, CddDisplayProcessor$.MODULE$.cdp());
        }
        throw NoExpectedException$.MODULE$.apply(s, NoExpectedException$.MODULE$.apply$default$2(), CddDisplayProcessor$.MODULE$.cdp());
    }

    public static void $init$(ValidateScenario $this) {
    }
}

