package org.cdk8s.grafana;

/**
 * A Grafana dashboard.
 * <p>
 * @see <a href="https://grafana.com/docs/grafana/latest/http_api/dashboard/">https://grafana.com/docs/grafana/latest/http_api/dashboard/</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-01T02:39:08.526Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.grafana.$Module.class, fqn = "cdk8s-grafana.Dashboard")
public class Dashboard extends software.constructs.Construct {

    protected Dashboard(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Dashboard(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Dashboard(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.grafana.DashboardProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds one or more plugins.
     * <p>
     * @param plugins This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPlugins(final @org.jetbrains.annotations.NotNull org.cdk8s.grafana.GrafanaPlugin... plugins) {
        software.amazon.jsii.Kernel.call(this, "addPlugins", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(plugins).toArray(Object[]::new));
    }

    /**
     * A fluent builder for {@link org.cdk8s.grafana.Dashboard}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.grafana.Dashboard> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.grafana.DashboardProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.grafana.DashboardProps.Builder();
        }

        /**
         * Title of the dashboard.
         * <p>
         * @return {@code this}
         * @param title Title of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * Specify a mapping from data source variables to data source names.
         * <p>
         * This is only needed if you are importing an existing dashboard's JSON
         * and it specifies variables within an "__inputs" field.
         * <p>
         * Default: - no data source variables
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * { DS_PROMETHEUS: "my-prometheus-ds" }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param dataSourceVariables Specify a mapping from data source variables to data source names. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceVariables(final java.util.Map<java.lang.String, java.lang.String> dataSourceVariables) {
            this.props.dataSourceVariables(dataSourceVariables);
            return this;
        }

        /**
         * Group dashboards into folders.
         * <p>
         * Default: - default folder
         * <p>
         * @return {@code this}
         * @param folder Group dashboards into folders. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folder(final java.lang.String folder) {
            this.props.folder(folder);
            return this;
        }

        /**
         * All other dashboard customizations.
         * <p>
         * @return {@code this}
         * @see <a href="https://grafana.com/docs/grafana/latest/dashboards/json-model/">https://grafana.com/docs/grafana/latest/dashboards/json-model/</a>
         * @param jsonModel All other dashboard customizations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonModel(final java.util.Map<java.lang.String, ? extends java.lang.Object> jsonModel) {
            this.props.jsonModel(jsonModel);
            return this;
        }

        /**
         * Labels to apply to the kubernetes resource.
         * <p>
         * When adding a dashboard to a Grafana instance using <code>grafana.addDashboard</code>,
         * labels provided to Grafana will be automatically applied. Otherwise,
         * labels must be added manually.
         * <p>
         * Default: - no labels
         * <p>
         * @return {@code this}
         * @param labels Labels to apply to the kubernetes resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final java.util.Map<java.lang.String, java.lang.String> labels) {
            this.props.labels(labels);
            return this;
        }

        /**
         * Namespace to apply to the kubernetes resource.
         * <p>
         * When adding a dashboard to a Grafana instance using <code>grafana.addDashboard</code>,
         * the namespace will be automatically inherited.
         * <p>
         * Default: - undefined (will be assigned to the 'default' namespace)
         * <p>
         * @return {@code this}
         * @param namespace Namespace to apply to the kubernetes resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(final java.lang.String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * Specify plugins required by the dashboard.
         * <p>
         * @return {@code this}
         * @param plugins Specify plugins required by the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plugins(final java.util.List<? extends org.cdk8s.grafana.GrafanaPlugin> plugins) {
            this.props.plugins(plugins);
            return this;
        }

        /**
         * Auto-refresh interval.
         * <p>
         * Default: - 5 seconds
         * <p>
         * @return {@code this}
         * @param refreshRate Auto-refresh interval. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshRate(final org.cdk8s.Duration refreshRate) {
            this.props.refreshRate(refreshRate);
            return this;
        }

        /**
         * Time range for the dashboard, e.g. last 6 hours, last 7 days, etc.
         * <p>
         * Default: - 6 hours
         * <p>
         * @return {@code this}
         * @param timeRange Time range for the dashboard, e.g. last 6 hours, last 7 days, etc. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeRange(final org.cdk8s.Duration timeRange) {
            this.props.timeRange(timeRange);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.grafana.Dashboard}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.grafana.Dashboard build() {
            return new org.cdk8s.grafana.Dashboard(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
