/**
 * <h2>cdk8s-grafana</h2>
 * <p>
 * <a href="https://constructs.dev/packages/cdk8s-grafana"><img alt="View on Construct Hub" src="https://constructs.dev/badge?package=cdk8s-grafana"></a>
 * <p>
 * cdk8s-grafana is a library that lets you easily define a Grafana service for
 * your kubernetes cluster along with associated dashboards and datasources, using
 * a high level API.
 * <p>
 * <h3>Usage</h3>
 * <p>
 * To apply the resources generated by this construct, the Grafana operator must be
 * installed on your cluster. See
 * <a href="https://operatorhub.io/operator/grafana-operator">https://operatorhub.io/operator/grafana-operator</a> for full installation
 * instructions.
 * <p>
 * The following will define a Grafana cluster connected to a Prometheus
 * datasource:
 * <p>
 * <blockquote><pre>
 * import { Grafana } from 'cdk8s-grafana';
 * 
 * // inside your chart:
 * const grafana = new Grafana(this, 'my-grafana', {
 *   defaultDataSource: {
 *     name: 'Prometheus',
 *     type: 'prometheus',
 *     access: 'proxy',
 *     url: 'http://prometheus-service:9090',
 *   }
 * });
 * </pre></blockquote>
 * <p>
 * Basic aspects of a dashboard can be customized:
 * <p>
 * <blockquote><pre>
 * const github = grafana.addDatasource('github', ...);
 * const dashboard = grafana.addDashboard('my-dashboard', {
 *   title: 'My Dashboard',
 *   refreshRate: Duration.seconds(10),
 *   timeRange: Duration.hours(6), // show metrics from now-6h to now
 *   plugins: [
 *     {
 *       name: 'grafana-piechart-panel',
 *       version: '1.3.6',
 *     }
 *   ],
 * });
 * </pre></blockquote>
 * <p>
 * Note: the kubernetes grafana operator only supports one Grafana instance per
 * namespace (see https://github.com/grafana-operator/grafana-operator/issues/174).
 * This may require specifying namespaces explicitly, e.g.:
 * <p>
 * <blockquote><pre>
 * const devGrafana = new Grafana(this, 'my-grafana', {
 *   namespace: 'dev',
 * });
 * const prodGrafana = new Grafana(this, 'my-grafana', {
 *   namespace: 'prod',
 * });
 * </pre></blockquote>
 * <p>
 * The grafana operator must be installed in each namespace for the resources in
 * that namespace to be recognized.
 * <p>
 * <h2>Security</h2>
 * <p>
 * See <a href="CONTRIBUTING.md#security-issue-notifications">CONTRIBUTING</a> for more
 * information.
 * <p>
 * <h2>License</h2>
 * <p>
 * This project is licensed under the Apache-2.0 License.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package org.cdk8s.grafana;
