package org.cdk8s.grafana;

/**
 * A Grafana data source.
 * <p>
 * @see <a href="https://grafana.com/docs/grafana/latest/administration/provisioning/#example-data-source-config-file">https://grafana.com/docs/grafana/latest/administration/provisioning/#example-data-source-config-file</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.90.0 (build d6bdb4d)", date = "2023-10-14T06:09:34.723Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.grafana.$Module.class, fqn = "cdk8s-grafana.DataSource")
public class DataSource extends software.constructs.Construct {

    protected DataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.grafana.DataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.grafana.DataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.grafana.DataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.grafana.DataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.grafana.DataSourceProps.Builder();
        }

        /**
         * Access type of the data source.
         * <p>
         * @return {@code this}
         * @param access Access type of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder access(final org.cdk8s.grafana.AccessType access) {
            this.props.access(access);
            return this;
        }

        /**
         * Name of the data source.
         * <p>
         * @return {@code this}
         * @param name Name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Type of the data source.
         * <p>
         * @return {@code this}
         * @param type Type of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Description of the data source.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description Description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Labels to apply to the kubernetes resource.
         * <p>
         * When adding a data source to a Grafana instance using <code>grafana.addDataSource</code>,
         * labels provided to Grafana will be automatically applied. Otherwise,
         * labels must be added manually.
         * <p>
         * Default: - no labels
         * <p>
         * @return {@code this}
         * @param labels Labels to apply to the kubernetes resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final java.util.Map<java.lang.String, java.lang.String> labels) {
            this.props.labels(labels);
            return this;
        }

        /**
         * Namespace to apply to the kubernetes resource.
         * <p>
         * When adding a data source to a Grafana instance using <code>grafana.addDataSource</code>,
         * the namespace will be automatically inherited.
         * <p>
         * Default: - undefined (will be assigned to the 'default' namespace)
         * <p>
         * @return {@code this}
         * @param namespace Namespace to apply to the kubernetes resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(final java.lang.String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * URL of the data source.
         * <p>
         * Most resources besides the 'testdata' data source
         * type require this field in order to retrieve data.
         * <p>
         * Default: - default url for data source type
         * <p>
         * @return {@code this}
         * @param url URL of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(final java.lang.String url) {
            this.props.url(url);
            return this;
        }

        /**
         * @return a newly built instance of {@link org.cdk8s.grafana.DataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.grafana.DataSource build() {
            return new org.cdk8s.grafana.DataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
