package org.cdk8s.grafana;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-12T12:16:55.611Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.grafana.$Module.class, fqn = "cdk8s-grafana.DashboardProps")
@software.amazon.jsii.Jsii.Proxy(DashboardProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DashboardProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Title of the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTitle();

    /**
     * Specify a mapping from data source variables to data source names.
     * <p>
     * This is only needed if you are importing an existing dashboard's JSON
     * and it specifies variables within an "__inputs" field.
     * <p>
     * Default: - no data source variables
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * { DS_PROMETHEUS: "my-prometheus-ds" }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDataSourceVariables() {
        return null;
    }

    /**
     * Group dashboards into folders.
     * <p>
     * Default: - default folder
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFolder() {
        return null;
    }

    /**
     * All other dashboard customizations.
     * <p>
     * @see <a href="https://grafana.com/docs/grafana/latest/dashboards/json-model/">https://grafana.com/docs/grafana/latest/dashboards/json-model/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getJsonModel() {
        return null;
    }

    /**
     * Labels to apply to the kubernetes resource.
     * <p>
     * When adding a dashboard to a Grafana instance using <code>grafana.addDashboard</code>,
     * labels provided to Grafana will be automatically applied. Otherwise,
     * labels must be added manually.
     * <p>
     * Default: - no labels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * Namespace to apply to the kubernetes resource.
     * <p>
     * When adding a dashboard to a Grafana instance using <code>grafana.addDashboard</code>,
     * the namespace will be automatically inherited.
     * <p>
     * Default: - undefined (will be assigned to the 'default' namespace)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return null;
    }

    /**
     * Specify plugins required by the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.grafana.GrafanaPlugin> getPlugins() {
        return null;
    }

    /**
     * Auto-refresh interval.
     * <p>
     * Default: - 5 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.Duration getRefreshRate() {
        return null;
    }

    /**
     * Time range for the dashboard, e.g. last 6 hours, last 7 days, etc.
     * <p>
     * Default: - 6 hours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.Duration getTimeRange() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DashboardProps> {
        java.lang.String title;
        java.util.Map<java.lang.String, java.lang.String> dataSourceVariables;
        java.lang.String folder;
        java.util.Map<java.lang.String, java.lang.Object> jsonModel;
        java.util.Map<java.lang.String, java.lang.String> labels;
        java.lang.String namespace;
        java.util.List<org.cdk8s.grafana.GrafanaPlugin> plugins;
        org.cdk8s.Duration refreshRate;
        org.cdk8s.Duration timeRange;

        /**
         * Sets the value of {@link DashboardProps#getTitle}
         * @param title Title of the dashboard. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getDataSourceVariables}
         * @param dataSourceVariables Specify a mapping from data source variables to data source names.
         *                            This is only needed if you are importing an existing dashboard's JSON
         *                            and it specifies variables within an "__inputs" field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceVariables(java.util.Map<java.lang.String, java.lang.String> dataSourceVariables) {
            this.dataSourceVariables = dataSourceVariables;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getFolder}
         * @param folder Group dashboards into folders.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folder(java.lang.String folder) {
            this.folder = folder;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getJsonModel}
         * @param jsonModel All other dashboard customizations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder jsonModel(java.util.Map<java.lang.String, ? extends java.lang.Object> jsonModel) {
            this.jsonModel = (java.util.Map<java.lang.String, java.lang.Object>)jsonModel;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getLabels}
         * @param labels Labels to apply to the kubernetes resource.
         *               When adding a dashboard to a Grafana instance using <code>grafana.addDashboard</code>,
         *               labels provided to Grafana will be automatically applied. Otherwise,
         *               labels must be added manually.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getNamespace}
         * @param namespace Namespace to apply to the kubernetes resource.
         *                  When adding a dashboard to a Grafana instance using <code>grafana.addDashboard</code>,
         *                  the namespace will be automatically inherited.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getPlugins}
         * @param plugins Specify plugins required by the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder plugins(java.util.List<? extends org.cdk8s.grafana.GrafanaPlugin> plugins) {
            this.plugins = (java.util.List<org.cdk8s.grafana.GrafanaPlugin>)plugins;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getRefreshRate}
         * @param refreshRate Auto-refresh interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshRate(org.cdk8s.Duration refreshRate) {
            this.refreshRate = refreshRate;
            return this;
        }

        /**
         * Sets the value of {@link DashboardProps#getTimeRange}
         * @param timeRange Time range for the dashboard, e.g. last 6 hours, last 7 days, etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeRange(org.cdk8s.Duration timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DashboardProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DashboardProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashboardProps {
        private final java.lang.String title;
        private final java.util.Map<java.lang.String, java.lang.String> dataSourceVariables;
        private final java.lang.String folder;
        private final java.util.Map<java.lang.String, java.lang.Object> jsonModel;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final java.lang.String namespace;
        private final java.util.List<org.cdk8s.grafana.GrafanaPlugin> plugins;
        private final org.cdk8s.Duration refreshRate;
        private final org.cdk8s.Duration timeRange;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSourceVariables = software.amazon.jsii.Kernel.get(this, "dataSourceVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.folder = software.amazon.jsii.Kernel.get(this, "folder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jsonModel = software.amazon.jsii.Kernel.get(this, "jsonModel", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.plugins = software.amazon.jsii.Kernel.get(this, "plugins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.grafana.GrafanaPlugin.class)));
            this.refreshRate = software.amazon.jsii.Kernel.get(this, "refreshRate", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
            this.timeRange = software.amazon.jsii.Kernel.get(this, "timeRange", software.amazon.jsii.NativeType.forClass(org.cdk8s.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
            this.dataSourceVariables = builder.dataSourceVariables;
            this.folder = builder.folder;
            this.jsonModel = (java.util.Map<java.lang.String, java.lang.Object>)builder.jsonModel;
            this.labels = builder.labels;
            this.namespace = builder.namespace;
            this.plugins = (java.util.List<org.cdk8s.grafana.GrafanaPlugin>)builder.plugins;
            this.refreshRate = builder.refreshRate;
            this.timeRange = builder.timeRange;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDataSourceVariables() {
            return this.dataSourceVariables;
        }

        @Override
        public final java.lang.String getFolder() {
            return this.folder;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getJsonModel() {
            return this.jsonModel;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.util.List<org.cdk8s.grafana.GrafanaPlugin> getPlugins() {
            return this.plugins;
        }

        @Override
        public final org.cdk8s.Duration getRefreshRate() {
            return this.refreshRate;
        }

        @Override
        public final org.cdk8s.Duration getTimeRange() {
            return this.timeRange;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("title", om.valueToTree(this.getTitle()));
            if (this.getDataSourceVariables() != null) {
                data.set("dataSourceVariables", om.valueToTree(this.getDataSourceVariables()));
            }
            if (this.getFolder() != null) {
                data.set("folder", om.valueToTree(this.getFolder()));
            }
            if (this.getJsonModel() != null) {
                data.set("jsonModel", om.valueToTree(this.getJsonModel()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getPlugins() != null) {
                data.set("plugins", om.valueToTree(this.getPlugins()));
            }
            if (this.getRefreshRate() != null) {
                data.set("refreshRate", om.valueToTree(this.getRefreshRate()));
            }
            if (this.getTimeRange() != null) {
                data.set("timeRange", om.valueToTree(this.getTimeRange()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-grafana.DashboardProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DashboardProps.Jsii$Proxy that = (DashboardProps.Jsii$Proxy) o;

            if (!title.equals(that.title)) return false;
            if (this.dataSourceVariables != null ? !this.dataSourceVariables.equals(that.dataSourceVariables) : that.dataSourceVariables != null) return false;
            if (this.folder != null ? !this.folder.equals(that.folder) : that.folder != null) return false;
            if (this.jsonModel != null ? !this.jsonModel.equals(that.jsonModel) : that.jsonModel != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            if (this.plugins != null ? !this.plugins.equals(that.plugins) : that.plugins != null) return false;
            if (this.refreshRate != null ? !this.refreshRate.equals(that.refreshRate) : that.refreshRate != null) return false;
            return this.timeRange != null ? this.timeRange.equals(that.timeRange) : that.timeRange == null;
        }

        @Override
        public final int hashCode() {
            int result = this.title.hashCode();
            result = 31 * result + (this.dataSourceVariables != null ? this.dataSourceVariables.hashCode() : 0);
            result = 31 * result + (this.folder != null ? this.folder.hashCode() : 0);
            result = 31 * result + (this.jsonModel != null ? this.jsonModel.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.plugins != null ? this.plugins.hashCode() : 0);
            result = 31 * result + (this.refreshRate != null ? this.refreshRate.hashCode() : 0);
            result = 31 * result + (this.timeRange != null ? this.timeRange.hashCode() : 0);
            return result;
        }
    }
}
