package org.cdk8s.jenkins;

/**
 * A jenkins instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.81.0 (build 80988b0)", date = "2023-05-12T00:26:07.015Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.jenkins.$Module.class, fqn = "cdk8s-jenkins.Jenkins")
public class Jenkins extends software.constructs.Construct {

    protected Jenkins(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Jenkins(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Jenkins(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.jenkins.JenkinsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Jenkins(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add base plugins to jenkins instance.
     * <p>
     * @param basePlugins List of base plugins. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addBasePlugins(final @org.jetbrains.annotations.NotNull org.cdk8s.jenkins.Plugin... basePlugins) {
        software.amazon.jsii.Kernel.call(this, "addBasePlugins", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(basePlugins).toArray(Object[]::new));
    }

    /**
     * Add custom plugins to jenkins instance.
     * <p>
     * @param plugins List of custom plugins. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPlugins(final @org.jetbrains.annotations.NotNull org.cdk8s.jenkins.Plugin... plugins) {
        software.amazon.jsii.Kernel.call(this, "addPlugins", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(plugins).toArray(Object[]::new));
    }

    /**
     * Add seed jobs to jenkins instance.
     * <p>
     * @param seedJobs List of seed jobs. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSeedJobs(final @org.jetbrains.annotations.NotNull org.cdk8s.jenkins.SeedJob... seedJobs) {
        software.amazon.jsii.Kernel.call(this, "addSeedJobs", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(seedJobs).toArray(Object[]::new));
    }

    /**
     * A fluent builder for {@link org.cdk8s.jenkins.Jenkins}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.jenkins.Jenkins> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.jenkins.JenkinsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * List of plugins required by Jenkins operator.
         * <p>
         * Default: - Default base plugins:
         *       { name: 'kubernetes', version: '1.31.3' },
         *       { name: 'workflow-job', version: '1145.v7f2433caa07f' },
         *       { name: 'workflow-aggregator', version: '2.6' },
         *       { name: 'git', version: '4.10.3' },
         *       { name: 'job-dsl', version: '1.78.1' },
         *       { name: 'configuration-as-code', version: '1414.v878271fc496f' },
         *       { name: 'kubernetes-credentials-provider', version: '0.20' }
         * <p>
         * @return {@code this}
         * @param basePlugins List of plugins required by Jenkins operator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePlugins(final java.util.List<? extends org.cdk8s.jenkins.Plugin> basePlugins) {
            this.props().basePlugins(basePlugins);
            return this;
        }

        /**
         * Toggle for CSRF Protection on Jenkins resource.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param disableCsrfProtection Toggle for CSRF Protection on Jenkins resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableCsrfProtection(final java.lang.Boolean disableCsrfProtection) {
            this.props().disableCsrfProtection(disableCsrfProtection);
            return this;
        }

        /**
         * Metadata associated with Jenkins resource.
         * <p>
         * Default: : Default metadata values:
         *  {
         *      name: An app-unique name generated by the chart,
         *      annotations: No annotations,
         *      labels: { app: 'jenkins' },
         *      namespace: default,
         *      finalizers: No finalizers,
         *      ownerReferences: Automatically set by Kubernetes
         *  }
         * <p>
         * @return {@code this}
         * @param metadata Metadata associated with Jenkins resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * List of custom plugins applied to Jenkins resource.
         * <p>
         * Default: - []
         * <p>
         * @return {@code this}
         * @param plugins List of custom plugins applied to Jenkins resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plugins(final java.util.List<? extends org.cdk8s.jenkins.Plugin> plugins) {
            this.props().plugins(plugins);
            return this;
        }

        /**
         * List of seed job configuration for Jenkins resource.
         * <p>
         * For more information about seed jobs, please take a look at { &#64;link https://github.com/jenkinsci/job-dsl-plugin/wiki/Tutorial---Using-the-Jenkins-Job-DSL Jenkins Seed Jobs Documentation }.
         * <p>
         * Default: - No seed jobs
         * <p>
         * @return {@code this}
         * @param seedJobs List of seed job configuration for Jenkins resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder seedJobs(final java.util.List<? extends org.cdk8s.jenkins.SeedJob> seedJobs) {
            this.props().seedJobs(seedJobs);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.jenkins.Jenkins}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.jenkins.Jenkins build() {
            return new org.cdk8s.jenkins.Jenkins(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.jenkins.JenkinsProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.jenkins.JenkinsProps.Builder();
            }
            return this.props;
        }
    }
}
