/**
 * <h1>cdk8s-jenkins</h1>
 * <p>
 * <code>cdk8s-jenkins</code> is a library that lets you easily define a manifest for deploying a Jenkins instance to your Kubernetes cluster.
 * <p>
 * <h2>Prerequisites</h2>
 * <p>
 * This library uses a Custom Resource Definition provided by jenkins, and thus requires both the CRD and the operator to be installed on the cluster.
 * You can set this up by,
 * <p>
 * <ol>
 * <li>Apply the Custom Resource Definition(CRD) for jenkins on your Kubernetes cluster.</li>
 * </ol>
 * <p>
 * <blockquote><pre>
 * kubectl apply -f https://raw.githubusercontent.com/jenkinsci/kubernetes-operator/master/config/crd/bases/jenkins.io_jenkins.yaml
 * </pre></blockquote>
 * <p>
 * <ol>
 * <li>Install the Jenkins Operator on your Kubernetes cluster.</li>
 * </ol>
 * <p>
 * <blockquote><pre>
 * kubectl apply -f https://raw.githubusercontent.com/jenkinsci/kubernetes-operator/master/deploy/all-in-one-v1alpha2.yaml
 * </pre></blockquote>
 * <p>
 * <blockquote>
 * <p>
 * For more information regarding applying jenkins crd and installing jenkins operator, please refer <a href="https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/installing-the-operator/">jenkins official documentaion</a>.
 * <p>
 * </blockquote>
 * <p>
 * <h2>Usage</h2>
 * <p>
 * The library provides a high level <code>Jenkins</code> construct to provision a Jenkins instance.
 * You can just instantiate the Jenkins instance and that would add a Jenkins resource to the kubernetes manifest.
 * <p>
 * The library provide a set of defaults, so provisioning a basic Jenkins instance requires no configuration:
 * <p>
 * <blockquote><pre>
 * import { Jenkins } from 'cdk8s-jenkins';
 * 
 * // inside your chart:
 * const jenkins = new Jenkins(this, 'my-jenkins');
 * </pre></blockquote>
 * <p>
 * The library also enables configuring the following parmeters for the Jenkins instance:
 * <p>
 * <h3>metadata</h3>
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins', {
 *   metadata: {
 *     namespace: 'jenkins-namespace',
 *     labels: { customApp: 'my-jenkins' },
 *   },
 * });
 * </pre></blockquote>
 * <p>
 * <h3>disableCsrfProtection</h3>
 * <p>
 * This allows you to toggle CSRF Protection for Jenkins.
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins', {
 *   disableCsrfProtection: true,
 * });
 * </pre></blockquote>
 * <p>
 * <h3>basePlugins</h3>
 * <p>
 * These are the plugins required by the jenkins operator.
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins', {
 *   basePlugins: [{
 *     name: 'configuration-as-code',
 *     version: '1.55',
 *     }],
 * });
 * </pre></blockquote>
 * <p>
 * You can also utilize <code>addBasePlugins</code> function to add base plugins to jenkins configuration after initialization.
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins');
 * jenkins.addBasePlugins([{
 *   name: 'workflow-api',
 *   version: '2.76',
 * }]);
 * </pre></blockquote>
 * <p>
 * <h3>plugins</h3>
 * <p>
 * These are the plugins that you can add to your jenkins instance.
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins', {
 *   plugins: [{
 *     name: 'simple-theme-plugin',
 *     version: '0.7',
 *     }],
 * });
 * </pre></blockquote>
 * <p>
 * You can also utilize <code>addPlugins</code> function to add plugins to jenkins configuration after initialization.
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins');
 * jenkins.addPlugins([{
 *   name: 'simple-theme-plugin',
 *   version: '0.7',
 * }]);
 * </pre></blockquote>
 * <p>
 * <h3>seedJobs</h3>
 * <p>
 * You can define list of jenkins seed job configurations here. For more info you can take look at <a href="https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/configuring-seed-jobs-and-pipelines/">jenkins documentation</a>.
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins', {
 *   seedJobs: [{
 *     id: 'jenkins-operator',
 *     targets: 'cicd/jobs/*.jenkins',
 *     description: 'Jenkins Operator repository',
 *     repositoryBranch: 'master',
 *     repositoryUrl: 'https://github.com/jenkinsci/kubernetes-operator.git',
 *     }],
 * });
 * </pre></blockquote>
 * <p>
 * You can also utilize <code>addSeedJobs</code> function to add seed jobs to jenkins configuration after initialization.
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins');
 * jenkins.addSeedJobs([{
 *   id: 'jenkins-operator',
 *   targets: 'cicd/jobs/*.jenkins',
 *   description: 'Jenkins Operator repository',
 *   repositoryBranch: 'master',
 *   repositoryUrl: 'https://github.com/jenkinsci/kubernetes-operator.git',
 * }]);
 * </pre></blockquote>
 * <p>
 * <h2>Using escape hatches</h2>
 * <p>
 * You can utilize escape hatches to make changes to the configurations that are not yet exposed by the library.
 * <p>
 * For instance, if you would like to update the version of a base plugin:
 * <p>
 * <blockquote><pre>
 * const jenkins = new Jenkins(this, 'my-jenkins');
 * const jenkinsApiObject = ApiObject.of(jenkins);
 * jenkinsApiObject.addJsonPatch(JsonPatch.replace('/spec/master/basePlugins/1', {
 *   name: 'workflow-job',
 *   version: '3.00',
 * }));
 * </pre></blockquote>
 * <p>
 * For more information regarding escape hatches, take a look at <a href="https://cdk8s.io/docs/latest/concepts/escape-hatches/">cdk8s documentation</a>.
 * <p>
 * <h2>Security</h2>
 * <p>
 * See <a href="CONTRIBUTING.md#security-issue-notifications">CONTRIBUTING</a> for more
 * information.
 * <p>
 * <h2>License</h2>
 * <p>
 * This project is licensed under the Apache-2.0 License.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package org.cdk8s.jenkins;
