package org.cdk8s.cdk8soperator;

/**
 * A CDK8s app which allows implementing Kubernetes operators using CDK8s constructs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-03-24T00:27:05.846Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.cdk8soperator.$Module.class, fqn = "cdk8s-operator.Operator")
public class Operator extends org.cdk8s.App {

    protected Operator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Operator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Operator(final @org.jetbrains.annotations.Nullable org.cdk8s.cdk8soperator.OperatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Operator() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Adds a custom resource provider to this operator.
     * <p>
     * @param provider The provider to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addProvider(final @org.jetbrains.annotations.NotNull org.cdk8s.cdk8soperator.CustomResourceProvider provider) {
        software.amazon.jsii.Kernel.call(this, "addProvider", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(provider, "provider is required") });
    }

    /**
     * Reads a Kubernetes manifest in JSON format from STDIN or the file specified as the first positional command-line argument.
     * <p>
     * This manifest is expected to
     * include a single Kubernetes resource. Then, we match <code>apiVersion</code> and
     * <code>kind</code> to one of the registered providers and if we do, we invoke
     * <code>apply()</code>, passing it the <code>spec</code> of the input manifest and a chart as a
     * scope. The chart is then synthesized and the output manifest is written to
     * STDOUT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synth() {
        software.amazon.jsii.Kernel.call(this, "synth", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * A fluent builder for {@link org.cdk8s.cdk8soperator.Operator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.cdk8soperator.Operator> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private org.cdk8s.cdk8soperator.OperatorProps.Builder props;

        private Builder() {
        }

        /**
         * A Kubernetes JSON manifest with a single resource that is matched against one of the providers within this operator.
         * <p>
         * Default: - first position command-line argument or "/dev/stdin"
         * <p>
         * @return {@code this}
         * @param inputFile A Kubernetes JSON manifest with a single resource that is matched against one of the providers within this operator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputFile(final java.lang.String inputFile) {
            this.props().inputFile(inputFile);
            return this;
        }

        /**
         * Where to write the synthesized output.
         * <p>
         * Default: "/dev/stdout"
         * <p>
         * @return {@code this}
         * @param outputFile Where to write the synthesized output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputFile(final java.lang.String outputFile) {
            this.props().outputFile(outputFile);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.cdk8soperator.Operator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.cdk8soperator.Operator build() {
            return new org.cdk8s.cdk8soperator.Operator(
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.cdk8soperator.OperatorProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.cdk8soperator.OperatorProps.Builder();
            }
            return this.props;
        }
    }
}
