package org.cdk8s.plus21;

/**
 * Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.
 * <p>
 * An Ingress can be configured to give services
 * externally-reachable urls, load balance traffic, terminate SSL, offer name
 * based virtual hosting etc.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-09T02:33:01.407Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus21.$Module.class, fqn = "cdk8s-plus-21.IngressV1Beta1")
public class IngressV1Beta1 extends org.cdk8s.plus21.Resource {

    protected IngressV1Beta1(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IngressV1Beta1(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IngressV1Beta1(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus21.IngressV1Beta1Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IngressV1Beta1(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines the default backend for this ingress.
     * <p>
     * A default backend capable of
     * servicing requests that don't match any rule.
     * <p>
     * @param backend The backend to use for requests that do not match any rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDefaultBackend(final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.IngressV1Beta1Backend backend) {
        software.amazon.jsii.Kernel.call(this, "addDefaultBackend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(backend, "backend is required") });
    }

    /**
     * Specify a default backend for a specific host name.
     * <p>
     * This backend will be used as a catch-all for requests
     * targeted to this host name (the <code>Host</code> header matches this value).
     * <p>
     * @param host The host name to match. This parameter is required.
     * @param backend The backend to route to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addHostDefaultBackend(final @org.jetbrains.annotations.NotNull java.lang.String host, final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.IngressV1Beta1Backend backend) {
        software.amazon.jsii.Kernel.call(this, "addHostDefaultBackend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(host, "host is required"), java.util.Objects.requireNonNull(backend, "backend is required") });
    }

    /**
     * Adds an ingress rule applied to requests to a specific host and a specific HTTP path (the `Host` header matches this value).
     * <p>
     * @param host The host name. This parameter is required.
     * @param path The HTTP path. This parameter is required.
     * @param backend The backend to route requests to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addHostRule(final @org.jetbrains.annotations.NotNull java.lang.String host, final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.IngressV1Beta1Backend backend) {
        software.amazon.jsii.Kernel.call(this, "addHostRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(host, "host is required"), java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(backend, "backend is required") });
    }

    /**
     * Adds an ingress rule applied to requests sent to a specific HTTP path.
     * <p>
     * @param path The HTTP path. This parameter is required.
     * @param backend The backend to route requests to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addRule(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.IngressV1Beta1Backend backend) {
        software.amazon.jsii.Kernel.call(this, "addRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(backend, "backend is required") });
    }

    /**
     * Adds rules to this ingress.
     * <p>
     * @param rules The rules to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addRules(final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.IngressV1Beta1Rule... rules) {
        software.amazon.jsii.Kernel.call(this, "addRules", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(rules).toArray(Object[]::new));
    }

    /**
     * @param tls This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTls(final @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus21.IngressV1Beta1Tls> tls) {
        software.amazon.jsii.Kernel.call(this, "addTls", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(tls, "tls is required") });
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> onValidate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "onValidate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus21.IngressV1Beta1}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus21.IngressV1Beta1> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus21.IngressV1Beta1Props.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * The default backend services requests that do not match any rule.
         * <p>
         * Using this option or the <code>addDefaultBackend()</code> method is equivalent to
         * adding a rule with both <code>path</code> and <code>host</code> undefined.
         * <p>
         * @return {@code this}
         * @param defaultBackend The default backend services requests that do not match any rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBackend(final org.cdk8s.plus21.IngressV1Beta1Backend defaultBackend) {
            this.props().defaultBackend(defaultBackend);
            return this;
        }

        /**
         * Routing rules for this ingress.
         * <p>
         * Each rule must define an <code>IngressBackend</code> that will receive the requests
         * that match this rule. If both <code>host</code> and <code>path</code> are not specifiec, this
         * backend will be used as the default backend of the ingress.
         * <p>
         * You can also add rules later using <code>addRule()</code>, <code>addHostRule()</code>,
         * <code>addDefaultBackend()</code> and <code>addHostDefaultBackend()</code>.
         * <p>
         * @return {@code this}
         * @param rules Routing rules for this ingress. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final java.util.List<? extends org.cdk8s.plus21.IngressV1Beta1Rule> rules) {
            this.props().rules(rules);
            return this;
        }

        /**
         * TLS settings for this ingress.
         * <p>
         * Using this option tells the ingress controller to expose a TLS endpoint.
         * Currently the Ingress only supports a single TLS port, 443. If multiple
         * members of this list specify different hosts, they will be multiplexed on
         * the same port according to the hostname specified through the SNI TLS
         * extension, if the ingress controller fulfilling the ingress supports SNI.
         * <p>
         * @return {@code this}
         * @param tls TLS settings for this ingress. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tls(final java.util.List<? extends org.cdk8s.plus21.IngressV1Beta1Tls> tls) {
            this.props().tls(tls);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus21.IngressV1Beta1}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus21.IngressV1Beta1 build() {
            return new org.cdk8s.plus21.IngressV1Beta1(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus21.IngressV1Beta1Props.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus21.IngressV1Beta1Props.Builder();
            }
            return this.props;
        }
    }
}
