package org.cdk8s.plus21;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.41.0 (build a274beb)", date = "2021-10-30T01:02:12.374Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus21.$Module.class, fqn = "cdk8s-plus-21.ServicePortOptions")
@software.amazon.jsii.Jsii.Proxy(ServicePortOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServicePortOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of this port within the service.
     * <p>
     * This must be a DNS_LABEL. All
     * ports within a ServiceSpec must have unique names. This maps to the 'Name'
     * field in EndpointPort objects. Optional if only one ServicePort is defined
     * on this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The port on each node on which this service is exposed when type=NodePort or LoadBalancer.
     * <p>
     * Usually assigned by the system. If specified, it will be
     * allocated to the service if unused or else creation of the service will
     * fail. Default is to auto-allocate a port if the ServiceType of this Service
     * requires one.
     * <p>
     * Default: - auto-allocate a port if the ServiceType of this Service requires one.
     * <p>
     * @see https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNodePort() {
        return null;
    }

    /**
     * The IP protocol for this port.
     * <p>
     * Supports "TCP", "UDP", and "SCTP". Default is TCP.
     * <p>
     * Default: Protocol.TCP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus21.Protocol getProtocol() {
        return null;
    }

    /**
     * The port number the service will redirect to.
     * <p>
     * Default: - The value of `port` will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServicePortOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServicePortOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServicePortOptions> {
        private java.lang.String name;
        private java.lang.Number nodePort;
        private org.cdk8s.plus21.Protocol protocol;
        private java.lang.Number targetPort;

        /**
         * Sets the value of {@link ServicePortOptions#getName}
         * @param name The name of this port within the service.
         *             This must be a DNS_LABEL. All
         *             ports within a ServiceSpec must have unique names. This maps to the 'Name'
         *             field in EndpointPort objects. Optional if only one ServicePort is defined
         *             on this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ServicePortOptions#getNodePort}
         * @param nodePort The port on each node on which this service is exposed when type=NodePort or LoadBalancer.
         *                 Usually assigned by the system. If specified, it will be
         *                 allocated to the service if unused or else creation of the service will
         *                 fail. Default is to auto-allocate a port if the ServiceType of this Service
         *                 requires one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodePort(java.lang.Number nodePort) {
            this.nodePort = nodePort;
            return this;
        }

        /**
         * Sets the value of {@link ServicePortOptions#getProtocol}
         * @param protocol The IP protocol for this port.
         *                 Supports "TCP", "UDP", and "SCTP". Default is TCP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(org.cdk8s.plus21.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link ServicePortOptions#getTargetPort}
         * @param targetPort The port number the service will redirect to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPort(java.lang.Number targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServicePortOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServicePortOptions build() {
            return new Jsii$Proxy(name, nodePort, protocol, targetPort);
        }
    }

    /**
     * An implementation for {@link ServicePortOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServicePortOptions {
        private final java.lang.String name;
        private final java.lang.Number nodePort;
        private final org.cdk8s.plus21.Protocol protocol;
        private final java.lang.Number targetPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodePort = software.amazon.jsii.Kernel.get(this, "nodePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus21.Protocol.class));
            this.targetPort = software.amazon.jsii.Kernel.get(this, "targetPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String name, final java.lang.Number nodePort, final org.cdk8s.plus21.Protocol protocol, final java.lang.Number targetPort) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = name;
            this.nodePort = nodePort;
            this.protocol = protocol;
            this.targetPort = targetPort;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getNodePort() {
            return this.nodePort;
        }

        @Override
        public final org.cdk8s.plus21.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.Number getTargetPort() {
            return this.targetPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNodePort() != null) {
                data.set("nodePort", om.valueToTree(this.getNodePort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getTargetPort() != null) {
                data.set("targetPort", om.valueToTree(this.getTargetPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-21.ServicePortOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServicePortOptions.Jsii$Proxy that = (ServicePortOptions.Jsii$Proxy) o;

            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.nodePort != null ? !this.nodePort.equals(that.nodePort) : that.nodePort != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.targetPort != null ? this.targetPort.equals(that.targetPort) : that.targetPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.nodePort != null ? this.nodePort.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.targetPort != null ? this.targetPort.hashCode() : 0);
            return result;
        }
    }
}
