package org.cdk8s.plus21;

/**
 * StatefulSet is the workload API object used to manage stateful applications.
 * <p>
 * Manages the deployment and scaling of a set of Pods, and provides guarantees
 * about the ordering and uniqueness of these Pods.
 * <p>
 * Like a Deployment, a StatefulSet manages Pods that are based on an identical
 * container spec. Unlike a Deployment, a StatefulSet maintains a sticky identity
 * for each of their Pods. These pods are created from the same spec, but are not
 * interchangeable: each has a persistent identifier that it maintains across any
 * rescheduling.
 * <p>
 * If you want to use storage volumes to provide persistence for your workload, you
 * can use a StatefulSet as part of the solution. Although individual Pods in a StatefulSet
 * are susceptible to failure, the persistent Pod identifiers make it easier to match existing
 * volumes to the new Pods that replace any that have failed.
 * <p>
 * <h2>Using StatefulSets</h2>
 * <p>
 * StatefulSets are valuable for applications that require one or more of the following.
 * <p>
 * <ul>
 * <li>Stable, unique network identifiers.</li>
 * <li>Stable, persistent storage.</li>
 * <li>Ordered, graceful deployment and scaling.</li>
 * <li>Ordered, automated rolling updates.</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.41.0 (build a274beb)", date = "2021-10-30T01:02:12.380Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus21.$Module.class, fqn = "cdk8s-plus-21.StatefulSet")
public class StatefulSet extends org.cdk8s.plus21.Resource implements org.cdk8s.plus21.IPodTemplate {

    protected StatefulSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StatefulSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StatefulSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.StatefulSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a container to the pod.
     * <p>
     * @param container This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus21.Container addContainer(final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.ContainerProps container) {
        return software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus21.Container.class), new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
    }

    /**
     * Add a volume to the pod.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addVolume(final @org.jetbrains.annotations.NotNull org.cdk8s.plus21.Volume volume) {
        software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * Configure a label selector to this deployment.
     * <p>
     * Pods that have the label will be selected by deployments configured with this spec.
     * <p>
     * @param key - The label key. This parameter is required.
     * @param value - The label value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void selectByLabel(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "selectByLabel", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The containers belonging to the pod.
     * <p>
     * Use <code>addContainer</code> to add containers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus21.Container> getContainers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus21.Container.class))));
    }

    /**
     * The labels this statefulset will match against in order to select pods.
     * <p>
     * Returns a a copy. Use <code>selectByLabel()</code> to add labels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getLabelSelector() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "labelSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Management policy to use for the set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus21.PodManagementPolicy getPodManagementPolicy() {
        return software.amazon.jsii.Kernel.get(this, "podManagementPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus21.PodManagementPolicy.class));
    }

    /**
     * Provides read/write access to the underlying pod metadata of the resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.ApiObjectMetadataDefinition getPodMetadata() {
        return software.amazon.jsii.Kernel.get(this, "podMetadata", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObjectMetadataDefinition.class));
    }

    /**
     * Number of desired pods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getReplicas() {
        return software.amazon.jsii.Kernel.get(this, "replicas", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The volumes associated with this pod.
     * <p>
     * Use <code>addVolume</code> to add volumes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus21.Volume> getVolumes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus21.Volume.class))));
    }

    /**
     * Restart policy for all containers within the pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus21.RestartPolicy getRestartPolicy() {
        return software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus21.RestartPolicy.class));
    }

    /**
     * The service account used to run this pod.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable org.cdk8s.plus21.IServiceAccount getServiceAccount() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus21.IServiceAccount.class));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus21.StatefulSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus21.StatefulSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final org.cdk8s.plus21.StatefulSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new org.cdk8s.plus21.StatefulSetProps.Builder();
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * List of containers belonging to the pod.
         * <p>
         * Containers cannot currently be
         * added or removed. There must be at least one container in a Pod.
         * <p>
         * You can add additionnal containers using <code>podSpec.addContainer()</code>
         * <p>
         * Default: - No containers. Note that a pod spec must include at least one container.
         * <p>
         * @return {@code this}
         * @param containers List of containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends org.cdk8s.plus21.ContainerProps> containers) {
            this.props.containers(containers);
            return this;
        }

        /**
         * Restart policy for all containers within the pod.
         * <p>
         * Default: RestartPolicy.ALWAYS
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
         * @param restartPolicy Restart policy for all containers within the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartPolicy(final org.cdk8s.plus21.RestartPolicy restartPolicy) {
            this.props.restartPolicy(restartPolicy);
            return this;
        }

        /**
         * A service account provides an identity for processes that run in a Pod.
         * <p>
         * When you (a human) access the cluster (for example, using kubectl), you are
         * authenticated by the apiserver as a particular User Account (currently this
         * is usually admin, unless your cluster administrator has customized your
         * cluster). Processes in containers inside pods can also contact the
         * apiserver. When they do, they are authenticated as a particular Service
         * Account (for example, default).
         * <p>
         * Default: - No service account.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * @param serviceAccount A service account provides an identity for processes that run in a Pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(final org.cdk8s.plus21.IServiceAccount serviceAccount) {
            this.props.serviceAccount(serviceAccount);
            return this;
        }

        /**
         * List of volumes that can be mounted by containers belonging to the pod.
         * <p>
         * You can also add volumes later using <code>podSpec.addVolume()</code>
         * <p>
         * Default: - No volumes.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/concepts/storage/volumes
         * @param volumes List of volumes that can be mounted by containers belonging to the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends org.cdk8s.plus21.Volume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        /**
         * The pod metadata.
         * <p>
         * @return {@code this}
         * @param podMetadata The pod metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podMetadata(final org.cdk8s.ApiObjectMetadata podMetadata) {
            this.props.podMetadata(podMetadata);
            return this;
        }

        /**
         * Service to associate with the statefulset.
         * <p>
         * @return {@code this}
         * @param service Service to associate with the statefulset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final org.cdk8s.plus21.Service service) {
            this.props.service(service);
            return this;
        }

        /**
         * Automatically allocates a pod selector for this statefulset.
         * <p>
         * If this is set to <code>false</code> you must define your selector through
         * <code>statefulset.podMetadata.addLabel()</code> and <code>statefulset.selectByLabel()</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param defaultSelector Automatically allocates a pod selector for this statefulset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSelector(final java.lang.Boolean defaultSelector) {
            this.props.defaultSelector(defaultSelector);
            return this;
        }

        /**
         * Pod management policy to use for this statefulset.
         * <p>
         * Default: PodManagementPolicy.ORDERED_READY
         * <p>
         * @return {@code this}
         * @param podManagementPolicy Pod management policy to use for this statefulset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podManagementPolicy(final org.cdk8s.plus21.PodManagementPolicy podManagementPolicy) {
            this.props.podManagementPolicy(podManagementPolicy);
            return this;
        }

        /**
         * Number of desired pods.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param replicas Number of desired pods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(final java.lang.Number replicas) {
            this.props.replicas(replicas);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus21.StatefulSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus21.StatefulSet build() {
            return new org.cdk8s.plus21.StatefulSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
